/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.util.helper;

import calemiutils.config.CUConfig;
import calemiutils.util.helper.StringHelper;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import org.lwjgl.input.Keyboard;

public class LoreHelper {
    public static void addDisabledLore(List<String> tooltip, int value) {
        if (value <= 0) {
            tooltip.add(ChatFormatting.RED + "" + ChatFormatting.ITALIC + "Disabled by config!");
        }
    }

    public static void addInformationLore(List<String> tooltip, String lore) {
        if (CUConfig.tooltips.showInfoOnTooltips) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                tooltip.add(ChatFormatting.ITALIC + lore);
            } else {
                tooltip.add(LoreHelper.getPlateText("Shift", ChatFormatting.AQUA) + " Info");
            }
        }
    }

    public static void addControlsLore(List<String> tooltip, String lore, Type type) {
        LoreHelper.addControlsLore(tooltip, lore, type, false);
    }

    public static void addControlsLore(List<String> tooltip, String lore, Type type, boolean isFirst) {
        if (CUConfig.tooltips.showControlsOnTooltips) {
            if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
                LoreHelper.addActionLore(tooltip, lore, type);
            } else if (isFirst) {
                tooltip.add(LoreHelper.getPlateText("Ctrl", ChatFormatting.AQUA) + " Controls");
            }
        }
    }

    public static void addCurrencyLore(List<String> tooltip, int currentCurrency) {
        LoreHelper.addCurrencyLore(tooltip, currentCurrency, 0);
    }

    public static void addCurrencyLore(List<String> tooltip, int currentCurrency, int maxCurrency) {
        tooltip.add("Currency: " + ChatFormatting.GOLD + StringHelper.printCurrency(currentCurrency) + (maxCurrency != 0 ? " / " + StringHelper.printCurrency(maxCurrency) : ""));
    }

    private static void addActionLore(List<String> tooltip, String lore, Type type) {
        tooltip.add(LoreHelper.getPlateText(type.getName(), ChatFormatting.YELLOW) + " " + lore);
    }

    private static String getPlateText(String text, ChatFormatting format) {
        return "[" + format + text + ChatFormatting.GRAY + "]";
    }

    public static enum Type {
        USE("Use"),
        USE_OPEN_HAND("Use-Open-Hand"),
        USE_WRENCH("Use-Wrench"),
        USE_WALLET("Use-Wallet"),
        USE_BOOK("Use-Book"),
        SNEAK_USE("Sneak-Use"),
        SNEAK_USE_BLUEPRINT("Sneak-Use-Blueprint"),
        SNEAK_BREAK_BLOCK("Sneak-Break-Block"),
        RELEASE_USE("Release Use"),
        LEFT_CLICK_BLOCK("Left-Click-Block"),
        SNEAK_LEFT_CLICK_BLOCK("Sneak-Left-Click-Block"),
        LEFT_CLICK_BLUEPRINT("Left-Click-Blueprint");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

