/*
 * Decompiled with CFR 0.152.
 */
package calemiutils.util.helper;

import calemiutils.config.CUConfig;
import calemiutils.security.ISecurity;
import calemiutils.tileentity.base.TileEntityBase;
import calemiutils.util.Location;
import calemiutils.util.UnitChatMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;

public class SecurityHelper {
    public static boolean openSecuredBlock(Location location, EntityPlayer player, boolean printError) {
        TileEntity tileEntity = location.getTileEntity();
        if (tileEntity instanceof ISecurity) {
            ISecurity security = (ISecurity)tileEntity;
            if (security.getSecurityProfile().isOwner(player.func_70005_c_()) || player.field_71075_bZ.field_75098_d || !CUConfig.misc.useSecurity) {
                return true;
            }
            if (printError) {
                SecurityHelper.printErrorMessage(location, player);
            }
        }
        return false;
    }

    public static void printErrorMessage(Location location, EntityPlayer player) {
        UnitChatMessage message = new UnitChatMessage(location.getBlock().func_149732_F(), player);
        if (!player.field_70170_p.field_72995_K) {
            message.printMessage(TextFormatting.RED, "This unit doesn't belong to you!");
        }
    }

    public static String getSecuredGuiName(TileEntityBase te) {
        if (te instanceof ISecurity) {
            return " (" + ((ISecurity)((Object)te)).getSecurityProfile().getOwnerName() + ")";
        }
        return "";
    }
}

