/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler;

import crazypants.enderio.api.tool.IConduitControl;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.conduit.ConduitDisplayMode;
import crazypants.enderio.base.handler.FovZoomHandler;
import crazypants.enderio.base.handler.darksteel.DarkSteelController;
import crazypants.enderio.base.handler.darksteel.StateController;
import crazypants.enderio.base.handler.darksteel.gui.PacketOpenDSU;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.baubles.BaublesUtil;
import crazypants.enderio.base.integration.thaumcraft.GogglesOfRevealingUpgrade;
import crazypants.enderio.base.integration.top.TheOneProbeUpgrade;
import crazypants.enderio.base.item.conduitprobe.PacketConduitProbeMode;
import crazypants.enderio.base.item.darksteel.upgrade.elytra.ElytraUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.explosive.ExplosiveUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.glider.GliderUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.jump.JumpUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.nightvision.NightVisionUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.sound.SoundDetectorUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.speed.SpeedUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.stepassist.StepAssistUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.storage.PacketOpenInventory;
import crazypants.enderio.base.item.magnet.ItemMagnet;
import crazypants.enderio.base.item.magnet.MagnetController;
import crazypants.enderio.base.item.magnet.PacketMagnetState;
import crazypants.enderio.base.item.yetawrench.PacketYetaWrenchDisplayMode;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.sound.IModSound;
import crazypants.enderio.base.sound.SoundHelper;
import crazypants.enderio.base.sound.SoundRegistry;
import crazypants.enderio.util.Prep;
import crazypants.enderio.util.StringUtil;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
public enum KeyTracker {
    inventory(23, "key.category.darksteelarmor", new InventoryAction()),
    dsu(0, "key.category.darksteelarmor", new DSUAction()),
    glidertoggle(34, "key.category.darksteelarmor", KeyTracker.all(KeyTracker.toggleStateAction(DarkSteelController::isGliderUpgradeEquipped, GliderUpgrade.INSTANCE), KeyTracker.toggleStateAction(DarkSteelController::isElytraUpgradeEquipped, ElytraUpgrade.INSTANCE))),
    soundlocator(0, "key.category.darksteelarmor", KeyTracker.toggleStateAction(DarkSteelController::isSoundDetectorUpgradeEquipped, SoundDetectorUpgrade.INSTANCE)),
    nightvision(25, "key.category.darksteelarmor", new NightVisionAction()),
    gogglesofrevealing(0, "key.category.darksteelarmor", KeyTracker.toggleStateAction(GogglesOfRevealingUpgrade::isUpgradeEquipped, GogglesOfRevealingUpgrade.INSTANCE)),
    stepassist(0, "key.category.darksteelarmor", KeyTracker.toggleStateAction(StepAssistUpgrade::isEquipped, StepAssistUpgrade.INSTANCE)),
    speed(0, "key.category.darksteelarmor", KeyTracker.toggleStateAction(SpeedUpgrade::isEquipped, SpeedUpgrade.SPEED_ONE)),
    jump(0, "key.category.darksteelarmor", KeyTracker.toggleStateAction(JumpUpgrade::isEquipped, JumpUpgrade.JUMP_ONE)),
    top(0, "key.category.darksteelarmor", new TopAction()),
    tnt(0, "key.category.darksteelarmor", KeyTracker.toggleStateAction(ExplosiveUpgrade::isEquipped, ExplosiveUpgrade.INSTANCE)),
    yetawrenchmode(21, "key.category.tools", new YetaWrenchAction()),
    magnet(0, "key.category.tools", new MagnetAction()),
    fovReset(0, "key.category.camera", new FovZoomHandler.FovResetAction()),
    fovUnReset(0, "key.category.camera", new FovZoomHandler.FovUnresetAction()),
    fovStore(0, "key.category.camera", new FovZoomHandler.FovStoreAction()),
    fovRecall(0, "key.category.camera", new FovZoomHandler.FovRecallAction()),
    fovPlus(0, "key.category.camera", null),
    fovMinus(0, "key.category.camera", null),
    fovPlusFast(0, "key.category.camera", null),
    fovMinusFast(0, "key.category.camera", null);

    @Nonnull
    private final KeyBinding binding;
    private final Action action;

    private KeyTracker(@Nullable int keyCode, String category, Action action) {
        this.binding = new KeyBinding("enderio.keybind." + this.name().toLowerCase(Locale.ENGLISH), keyCode, StringUtil.trim(category));
        ClientRegistry.registerKeyBinding((KeyBinding)this.binding);
        this.action = action;
    }

    @Nonnull
    public KeyBinding getBinding() {
        return this.binding;
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        for (KeyTracker tracker : KeyTracker.values()) {
            if (tracker.action == null || !tracker.binding.func_151468_f()) continue;
            tracker.action.execute();
        }
    }

    @Nonnull
    public static Action toggleStateAction(@Nonnull Predicate<EntityPlayer> condition, @Nonnull IDarkSteelUpgrade type) {
        return () -> {
            if (condition.test((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                boolean isActive = !StateController.isActive((EntityPlayer)Minecraft.func_71410_x().field_71439_g, type);
                StringUtil.sendEnabledChatMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, type.getUnlocalizedName(), isActive);
                StateController.setActive((EntityPlayer)Minecraft.func_71410_x().field_71439_g, type, isActive);
            }
        };
    }

    @Nonnull
    public static Action all(Action ... actions) {
        return () -> {
            for (Action action : actions) {
                action.execute();
            }
        };
    }

    private static class TopAction
    implements Action {
        private TopAction() {
        }

        @Override
        public void execute() {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (DarkSteelController.isTopUpgradeEquipped((EntityPlayer)player)) {
                boolean isActive = !DarkSteelController.isTopActive((EntityPlayer)player);
                DarkSteelController.setTopActive((EntityPlayer)player, isActive);
                StringUtil.sendEnabledChatMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, TheOneProbeUpgrade.INSTANCE.getUnlocalizedName(), isActive);
            }
        }
    }

    private static class NightVisionAction
    implements Action {
        private NightVisionAction() {
        }

        @Override
        public void execute() {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (DarkSteelController.isNightVisionUpgradeEquipped((EntityPlayer)player)) {
                boolean isActive;
                boolean bl = isActive = !StateController.isActive((EntityPlayer)player, NightVisionUpgrade.INSTANCE);
                if (isActive) {
                    SoundHelper.playSound(player.field_70170_p, (Entity)player, (IModSound)SoundRegistry.NIGHTVISION_ON, 0.1f, player.field_70170_p.field_73012_v.nextFloat() * 0.4f - 0.2f + 1.0f);
                } else {
                    SoundHelper.playSound(player.field_70170_p, (Entity)player, (IModSound)SoundRegistry.NIGHTVISION_OFF, 0.1f, 1.0f);
                }
                StateController.setActive((EntityPlayer)player, NightVisionUpgrade.INSTANCE, isActive);
                StringUtil.sendEnabledChatMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, NightVisionUpgrade.INSTANCE.getUnlocalizedName(), isActive);
            }
        }
    }

    private static class YetaWrenchAction
    implements Action {
        private YetaWrenchAction() {
        }

        @Override
        public void execute() {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack equipped = player.func_184614_ca();
            if (Prep.isInvalid(equipped)) {
                return;
            }
            if (equipped.func_77973_b() instanceof IConduitControl) {
                ConduitDisplayMode curMode = ConduitDisplayMode.getDisplayMode(equipped);
                ConduitDisplayMode newMode = player.func_70093_af() ? curMode.previous() : curMode.next();
                ConduitDisplayMode.setDisplayMode(equipped, newMode);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketYetaWrenchDisplayMode(player.field_71071_by.field_70461_c, newMode));
            } else if (equipped.func_77973_b() == ModObject.itemConduitProbe.getItemNN()) {
                int newMeta = equipped.func_77952_i() == 0 ? 1 : 0;
                equipped.func_77964_b(newMeta);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketConduitProbeMode());
                player.func_184609_a(EnumHand.MAIN_HAND);
            }
        }
    }

    private static class DSUAction
    implements Action {
        private DSUAction() {
        }

        @Override
        public void execute() {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketOpenDSU());
        }
    }

    private static class InventoryAction
    implements Action {
        private InventoryAction() {
        }

        @Override
        public void execute() {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketOpenInventory());
        }
    }

    private static class MagnetAction
    implements Action {
        private MagnetAction() {
        }

        @Override
        public void execute() {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            MagnetController.ActiveMagnet activeMagnet = MagnetController.getMagnet((EntityPlayer)player, false);
            if (activeMagnet != null) {
                boolean isActive = !ItemMagnet.isActive(activeMagnet.getItem());
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketMagnetState(PacketMagnetState.SlotType.INVENTORY, activeMagnet.getSlot(), isActive));
                return;
            }
            IInventory baubles = BaublesUtil.instance().getBaubles((EntityPlayer)player);
            if (baubles != null) {
                for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                    ItemStack stack = baubles.func_70301_a(i);
                    if (!ItemMagnet.isMagnet(stack)) continue;
                    boolean isActive = !ItemMagnet.isActive(stack);
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketMagnetState(PacketMagnetState.SlotType.BAUBLES, i, isActive));
                    return;
                }
            }
        }
    }

    public static interface Action {
        public void execute();
    }

    private static final class CATEGORY {
        @Nonnull
        private static final String DARKSTEELARMOR = "key.category.darksteelarmor";
        @Nonnull
        private static final String TOOLS = "key.category.tools";
        @Nonnull
        private static final String CAMERA = "key.category.camera";

        private CATEGORY() {
        }
    }
}

