/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.xp;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.xp.XpUtil;
import io.netty.buffer.ByteBuf;
import java.security.InvalidParameterException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;

public class ExperienceContainer
extends FluidTank {
    private int experienceTotal;
    private boolean xpDirty;
    private final int maxXp;

    public ExperienceContainer() {
        this(Integer.MAX_VALUE);
    }

    public ExperienceContainer(int maxStored) {
        super(null, 0);
        this.maxXp = Math.min(maxStored, XpUtil.liquidToExperience(Integer.MAX_VALUE));
    }

    public int getMaximumExperience() {
        return this.maxXp;
    }

    public int getExperienceLevel() {
        return XpUtil.getLevelForExperience(this.experienceTotal);
    }

    public float getExperience() {
        return (float)(this.experienceTotal - XpUtil.getExperienceForLevel(this.getExperienceLevel())) / (float)this.getXpBarCapacity();
    }

    public int getExperienceTotal() {
        return this.experienceTotal;
    }

    public boolean isDirty() {
        return this.xpDirty;
    }

    public void setDirty(boolean isDirty) {
        this.xpDirty = isDirty;
    }

    public void set(@Nonnull ExperienceContainer xpCon) {
        this.experienceTotal = xpCon.experienceTotal;
        this.onContentsChanged();
    }

    public int addExperience(int xpToAdd) {
        int j = MathHelper.func_76125_a((int)xpToAdd, (int)0, (int)(this.maxXp - this.experienceTotal));
        this.experienceTotal += j;
        this.xpDirty = true;
        this.onContentsChanged();
        return j;
    }

    public int removeExperience(int xpToRemove) {
        int j = MathHelper.func_76125_a((int)xpToRemove, (int)0, (int)this.experienceTotal);
        this.experienceTotal -= j;
        this.xpDirty = true;
        this.onContentsChanged();
        return j;
    }

    private int getXpBarCapacity() {
        return XpUtil.getXpBarCapacity(this.getExperienceLevel());
    }

    public int getXpBarScaled(int scale) {
        int result = (int)(this.getExperience() * (float)scale);
        return result;
    }

    public void givePlayerXp(@Nonnull EntityPlayer player, int levels) throws XpUtil.TooManyXPLevelsException {
        for (int i = 0; i < levels && this.experienceTotal > 0; ++i) {
            this.givePlayerXpLevel(player);
        }
    }

    public void givePlayerXpLevel(@Nonnull EntityPlayer player) throws XpUtil.TooManyXPLevelsException {
        int currentXP = XpUtil.getPlayerXP(player);
        int nextLevelXP = XpUtil.getExperienceForLevel(player.field_71068_ca + 1);
        int requiredXP = nextLevelXP - currentXP;
        XpUtil.addPlayerXP(player, this.removeExperience(requiredXP));
    }

    public void drainPlayerXpToReachContainerLevel(@Nonnull EntityPlayer player, int level) throws XpUtil.TooManyXPLevelsException {
        if (level >= 0 && level <= XpUtil.getMaxLevelsStorable()) {
            int targetXP = XpUtil.getExperienceForLevel(level);
            int requiredXP = targetXP - this.experienceTotal;
            if (requiredXP <= 0) {
                return;
            }
            int drainXP = Math.min(requiredXP, XpUtil.getPlayerXP(player));
            this.addExperience(drainXP);
            XpUtil.addPlayerXP(player, -drainXP);
        } else {
            Log.info("Invalid Call to drainPlayerXpToReachContainerLevel(), target level of ", level, " is out of range.");
        }
    }

    public void drainPlayerXpToReachPlayerLevel(@Nonnull EntityPlayer player, int level) throws XpUtil.TooManyXPLevelsException {
        if (level >= 0 && level <= XpUtil.getMaxLevelsStorable()) {
            int targetXP = XpUtil.getExperienceForLevel(level);
            int drainXP = XpUtil.getPlayerXP(player) - targetXP;
            if (drainXP <= 0) {
                return;
            }
            if ((drainXP = this.addExperience(drainXP)) > 0) {
                XpUtil.addPlayerXP(player, -drainXP);
            }
        } else {
            Log.info("Invalid Call to drainPlayerXpToReachPlayerLevel(), target level of ", level, " is out of range.");
        }
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.canDrain(from, resource.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        int available = this.getFluidAmount();
        int toDrain = Math.min(available, maxDrain);
        int xpAskedToExtract = XpUtil.liquidToExperience(toDrain);
        int fluidToExtract = XpUtil.experienceToLiquid(xpAskedToExtract);
        int xpToExtract = XpUtil.liquidToExperience(fluidToExtract);
        if (doDrain) {
            int newXp = this.experienceTotal - xpToExtract;
            this.experienceTotal = 0;
            this.addExperience(newXp);
        }
        return new FluidStack(Fluids.XP_JUICE.getFluid(), fluidToExtract);
    }

    public boolean canFill(EnumFacing from, Fluid fluidIn) {
        return this.canFill() && fluidIn != null && FluidUtil.areFluidsTheSame((Fluid)fluidIn, (Fluid)Fluids.XP_JUICE.getFluid());
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int xpSpace;
        if (resource == null) {
            return 0;
        }
        if (resource.amount <= 0) {
            return 0;
        }
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        int xp = XpUtil.liquidToExperience(resource.amount);
        int canFillXP = Math.min(xp, xpSpace = this.getMaximumExperience() - this.getExperienceTotal());
        if (canFillXP <= 0) {
            return 0;
        }
        if (doFill) {
            this.addExperience(canFillXP);
        }
        return XpUtil.experienceToLiquid(canFillXP);
    }

    public boolean canDrain(EnumFacing from, Fluid fluidIn) {
        return fluidIn != null && FluidUtil.areFluidsTheSame((Fluid)fluidIn, (Fluid)Fluids.XP_JUICE.getFluid());
    }

    @Nonnull
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{new FluidTankInfo(new FluidStack(Fluids.XP_JUICE.getFluid(), this.getFluidAmount()), this.getCapacity())};
    }

    public int getCapacity() {
        if (this.maxXp == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return XpUtil.experienceToLiquid(this.maxXp);
    }

    public int getFluidAmount() {
        return XpUtil.experienceToLiquid(this.experienceTotal);
    }

    @Nonnull
    public FluidTank readFromNBT(NBTTagCompound nbtRoot) {
        this.experienceTotal = nbtRoot.func_74762_e("experienceTotal");
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74768_a("experienceTotal", this.experienceTotal);
        return nbtRoot;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.experienceTotal);
    }

    public void fromBytes(ByteBuf buf) {
        this.experienceTotal = buf.readInt();
    }

    @Nonnull
    public FluidStack getFluid() {
        return new FluidStack(Fluids.XP_JUICE.getFluid(), this.getFluidAmount());
    }

    public FluidTankInfo getInfo() {
        return this.getTankInfo(null)[0];
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.fill(null, resource, doFill);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.drain(null, maxDrain, doDrain);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.drain(null, resource, doDrain);
    }

    public void setFluid(@Nullable FluidStack fluid) {
        this.experienceTotal = 0;
        if (fluid != null && fluid.getFluid() != null) {
            if (Fluids.XP_JUICE.getFluid() == fluid.getFluid()) {
                this.addExperience(XpUtil.liquidToExperience(fluid.amount));
            } else {
                throw new InvalidParameterException(fluid.getFluid() + " is no XP juice");
            }
        }
        this.xpDirty = true;
    }

    public void setCapacity(int capacity) {
        throw new InvalidParameterException();
    }

    protected void onContentsChanged() {
        super.onContentsChanged();
        if (this.tile instanceof ITankAccess) {
            ((ITankAccess)this.tile).setTanksDirty();
        } else if (this.tile != null) {
            this.tile.func_70296_d();
        }
    }
}

