/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.diagnostics.ConduitNeighborUpdateTracker;
import crazypants.enderio.base.handler.ServerTickHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public abstract class AbstractConduitNetwork<T extends IServerConduit, I extends T>
implements IConduitNetwork<T, I> {
    @Nonnull
    private final List<I> conduits = new ArrayList<I>();
    private long lastConduitListCheck = -1L;
    @Nonnull
    protected final Class<I> implClass;
    @Nonnull
    protected final Class<T> baseConduitClass;
    private static final EnumFacing[] WEDUNS = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH};

    protected AbstractConduitNetwork(@Nonnull Class<I> implClass, @Nonnull Class<T> baseConduitClass) {
        this.implClass = implClass;
        this.baseConduitClass = baseConduitClass;
    }

    @Override
    public void init(@Nonnull IConduitBundle tile, Collection<I> connections, @Nonnull World world) throws ConduitUtil.UnloadedBlockException {
        if (world.field_72995_K) {
            throw new UnsupportedOperationException();
        }
        for (IServerConduit con : connections) {
            IConduitNetwork<?, ?> network = con.getNetwork();
            if (network == null) continue;
            network.destroyNetwork();
        }
        this.setNetwork(world, tile);
    }

    @Override
    @Nonnull
    public final Class<T> getBaseConduitType() {
        return this.baseConduitClass;
    }

    @Override
    public void setNetwork(@Nonnull World world, @Nonnull IConduitBundle tile) throws ConduitUtil.UnloadedBlockException {
        LinkedList<T> candidates = new LinkedList<T>();
        candidates.add(tile.getConduit(this.getBaseConduitType()));
        while (!candidates.isEmpty()) {
            IConduitNetwork<?, ?> network;
            IServerConduit conduit = (IServerConduit)candidates.remove(0);
            if (conduit == null || !this.implClass.isAssignableFrom(conduit.getClass()) || (network = conduit.getNetwork()) == this) continue;
            if (network != null) {
                network.destroyNetwork();
            }
            if (!conduit.setNetwork(this)) continue;
            this.addConduit((IServerConduit)this.implClass.cast(conduit));
            candidates.addAll(ConduitUtil.getConnectedConduits(world, conduit.getBundle().getEntity().func_174877_v(), this.getBaseConduitType()));
        }
    }

    private boolean isSameTick() {
        long temp = EnderIO.proxy.getServerTickCount();
        if (this.lastConduitListCheck != temp) {
            this.lastConduitListCheck = temp;
            return false;
        }
        return true;
    }

    @Override
    public void addConduit(@Nonnull I newConduit) {
        if (this.conduits.isEmpty()) {
            ServerTickHandler.addListener(this);
            ServerTickHandler.addListener(newConduit.getBundle().getBundleworld(), (ServerTickHandler.IServerTickListener)this);
        }
        boolean doFullCheck = !this.isSameTick();
        BlockPos newPos = null;
        boolean error = false;
        IConduitBundle newBundle = newConduit.getBundle();
        TileEntity newte = newBundle.getEntity();
        if (!newte.func_145830_o()) {
            Log.info("Tried to add invalid (no world) conduit to network: ", newConduit);
            error = true;
        }
        if (newte.func_145837_r()) {
            Log.info("Tried to add invalid (invalidated) conduit to network: ", newConduit);
            error = true;
        }
        newPos = newte.func_174877_v();
        World newworld = newte.func_145831_w();
        if (!newworld.func_175667_e(newPos)) {
            Log.info("Tried to add invalid (unloaded) conduit to network: ", newConduit);
            error = true;
        }
        if (newworld.func_175625_s(newte.func_174877_v()) != newte) {
            Log.info("Tried to add invalid (world disagrees) conduit to network: ", newConduit);
            error = true;
        }
        if (error) {
            new Exception("trace for message above").printStackTrace();
            return;
        }
        if (!doFullCheck) {
            for (IServerConduit oldConduit : this.conduits) {
                if (newConduit == oldConduit) {
                    return;
                }
                if (!oldConduit.getBundle().getEntity().func_174877_v().equals((Object)newPos)) continue;
                doFullCheck = true;
                break;
            }
            if (!doFullCheck) {
                this.conduits.add(newConduit);
                return;
            }
        }
        ArrayList<I> old = new ArrayList<I>(this.conduits);
        this.conduits.clear();
        boolean newConduitIsBad = false;
        for (IServerConduit oldConduit : old) {
            BlockPos oldPos;
            if (newConduit == oldConduit) continue;
            IConduitBundle oldBundle = oldConduit.getBundle();
            TileEntity oldTe = oldBundle.getEntity();
            if (oldTe.func_145837_r() || !oldTe.func_145830_o()) {
                oldConduit.clearNetwork();
                continue;
            }
            World oldWorld = oldBundle.getBundleworld();
            if (!oldWorld.func_175667_e(oldPos = oldTe.func_174877_v())) {
                Log.info("Removed unloaded but valid conduit from network: " + oldConduit);
                oldConduit.clearNetwork();
                continue;
            }
            if (oldWorld.func_175625_s(oldPos) != oldTe) {
                oldConduit.clearNetwork();
                continue;
            }
            if (newPos.equals((Object)oldPos)) {
                Log.info("Tried to add invalid conduit to network! Old conduit: ", oldConduit, "/", oldBundle, " New conduit: ", newConduit, "/", oldBundle, " World says: ", oldWorld.func_175625_s(newPos));
                newConduitIsBad = true;
            }
            this.conduits.add(oldConduit);
        }
        if (!newConduitIsBad) {
            this.conduits.add(newConduit);
        }
    }

    @Override
    public void destroyNetwork() {
        for (IServerConduit con : this.conduits) {
            con.clearNetwork();
        }
        this.conduits.clear();
        ServerTickHandler.removeListener(this);
    }

    @Override
    @Nonnull
    public List<I> getConduits() {
        return this.conduits;
    }

    @Override
    public void sendBlockUpdatesForEntireNetwork() {
        ConduitNeighborUpdateTracker tracker = null;
        HashSet<BlockPos> notified = new HashSet<BlockPos>();
        for (IServerConduit con : this.conduits) {
            TileEntity te = con.getBundle().getEntity();
            if (!con.hasExternalConnections()) continue;
            BlockPos pos = te.func_174877_v();
            Block blockType = te.func_145838_q();
            World world = te.func_145831_w();
            if (!world.func_175667_e(pos)) continue;
            IBlockState bs = world.func_180495_p(pos);
            if (tracker == null) {
                tracker = new ConduitNeighborUpdateTracker("Conduit network " + this.getClass() + " was interrupted while notifying neighbors of changes");
            }
            tracker.start("World.notifyBlockUpdate() at " + pos);
            world.func_184138_a(pos, bs, bs, 3);
            tracker.stop();
            EnumSet<EnumFacing> sidesToNotify = EnumSet.noneOf(EnumFacing.class);
            for (EnumFacing side : WEDUNS) {
                IBlockState blockState;
                if (side == null) continue;
                BlockPos offset = pos.func_177972_a(side);
                if (!con.containsExternalConnection(side) || notified.contains(offset) || !world.func_175667_e(offset) || (blockState = world.func_180495_p(offset)).func_177230_c() == blockType || blockState.func_177230_c() == Blocks.field_150350_a) continue;
                sidesToNotify.add(side);
                notified.add(offset);
            }
            if (sidesToNotify.isEmpty()) continue;
            tracker.start("ForgeEventFactory.onNeighborNotify() at " + pos);
            boolean canceled = ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (IBlockState)bs, sidesToNotify, (boolean)false).isCanceled();
            tracker.stop();
            if (canceled) continue;
            for (EnumFacing side : sidesToNotify) {
                if (side == null) continue;
                BlockPos offset = pos.func_177972_a(side);
                tracker.start("World.notifyNeighborsOfStateChange() from " + pos + " to " + offset + " (" + world.func_180495_p(offset) + ")");
                world.func_190524_a(offset, blockType, pos);
                tracker.stop();
            }
        }
        if (tracker != null) {
            tracker.discard();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IConduit con : this.conduits) {
            sb.append(con.getBundle().getLocation());
            sb.append(", ");
        }
        return "AbstractConduitNetwork@" + Integer.toHexString(this.hashCode()) + " [conduits=" + sb.toString() + "]";
    }

    @Override
    @Deprecated
    public void tickStart(TickEvent.ServerTickEvent event, @Nullable Profiler profiler) {
    }

    @Override
    @Deprecated
    public void tickEnd(TickEvent.ServerTickEvent event, @Nullable Profiler profiler) {
    }
}

