/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.invpanel;

import com.enderio.core.common.TileEntityBase;
import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.config.config.PersonalConfig;
import crazypants.enderio.base.machine.base.block.AbstractMachineBlock;
import crazypants.enderio.base.machine.entity.EntityFallingMachine;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.ITintedBlock;
import crazypants.enderio.base.render.property.EnumRenderMode6;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.invpanel.config.InvpanelConfig;
import crazypants.enderio.invpanel.init.InvpanelObject;
import crazypants.enderio.invpanel.invpanel.BlockItemInventoryPanel;
import crazypants.enderio.invpanel.invpanel.GuiInventoryPanel;
import crazypants.enderio.invpanel.invpanel.InvPanelRenderMapper;
import crazypants.enderio.invpanel.invpanel.InventoryPanelContainer;
import crazypants.enderio.invpanel.invpanel.TileInventoryPanel;
import crazypants.enderio.util.FuncUtil;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInventoryPanel
extends AbstractMachineBlock<TileInventoryPanel>
implements ITintedBlock {
    private static final float BLOCK_SIZE = 0.25f;

    public static BlockInventoryPanel create(@Nonnull IModObject mo) {
        BlockInventoryPanel panel = new BlockInventoryPanel(mo);
        panel.init();
        return panel;
    }

    public BlockInventoryPanel(@Nonnull IModObject modObj) {
        super(InvpanelObject.blockInventoryPanel);
        this.func_149647_a(EnderIOTab.tabEnderIOInvpanel);
        this.setShape(this.mkShape(BlockFaceShape.SOLID));
        this.respectsGravity = InvpanelConfig.respectsGravity;
    }

    @Override
    public BlockItemInventoryPanel createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new BlockItemInventoryPanel(this));
    }

    @Override
    protected void initDefaultState() {
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(EnumRenderMode6.RENDER, (Comparable)((Object)EnumRenderMode6.AUTO)));
    }

    @Override
    protected void registerInSmartModelAttacher() {
        SmartModelAttacher.register((Block)this, EnumRenderMode6.RENDER, EnumRenderMode6.DEFAULTS, EnumRenderMode6.AUTO);
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRenderMode6.RENDER});
    }

    public boolean func_149662_c(@Nonnull IBlockState bs) {
        return false;
    }

    public boolean func_149637_q(@Nonnull IBlockState bs) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState bs) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        EnumFacing facing = this.getFacing(world, pos);
        return this.getBoundingBox(facing);
    }

    @Nonnull
    public AxisAlignedBB getBoundingBox(EnumFacing facing) {
        int x = 0;
        int y = 0;
        int z = 0;
        switch (facing) {
            case DOWN: {
                return new AxisAlignedBB((double)x, (double)((float)y + 0.75f), (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
            }
            case UP: {
                return new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)((float)y + 0.25f), (double)(z + 1));
            }
            case NORTH: {
                return new AxisAlignedBB((double)x, (double)y, (double)((float)z + 0.75f), (double)(x + 1), (double)(y + 1), (double)(z + 1));
            }
            case SOUTH: {
                return new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)((float)z + 0.25f));
            }
            case WEST: {
                return new AxisAlignedBB((double)((float)x + 0.75f), (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
            }
            case EAST: {
                return new AxisAlignedBB((double)x, (double)y, (double)z, (double)((float)x + 0.25f), (double)(y + 1), (double)(z + 1));
            }
        }
        return new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
    }

    private EnumFacing getFacing(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntityBase te = this.getTileEntitySafe(world, pos);
        if (te instanceof TileInventoryPanel) {
            return ((TileInventoryPanel)te).getFacing();
        }
        return EnumFacing.NORTH;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
    }

    @Override
    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileInventoryPanel te) {
        return new InventoryPanelContainer(player.field_71071_by, te);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileInventoryPanel te) {
        return new GuiInventoryPanel(te, (Container)new InventoryPanelContainer(player.field_71071_by, te));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return InvPanelRenderMapper.instance;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return InvPanelRenderMapper.instance;
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileInventoryPanel tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing()).addCacheKey(tileEntity.isActive());
    }

    @Override
    public boolean openGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumFacing side) {
        return super.openGui(world, pos, entityPlayer, side);
    }

    @Override
    protected void checkFallable(@Nonnull WorldServer worldIn, @Nonnull BlockPos pos) {
        if (pos.func_177956_o() >= 0 && BlockFalling.func_185759_i((IBlockState)worldIn.func_180495_p(pos.func_177977_b())) && BlockFalling.func_185759_i((IBlockState)this.getAttachmentBlockState(worldIn, pos))) {
            worldIn.func_72838_d((Entity)new EntityFallingMachine(worldIn, pos, (Block)this));
        }
    }

    @Nonnull
    private IBlockState getAttachmentBlockState(WorldServer worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177972_a(this.getFacing((IBlockAccess)worldIn, pos).func_176734_d()));
    }

    @Override
    public int getBlockTint(@Nonnull IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
        return tintIndex > 0 && world != null && pos != null ? FuncUtil.runIf(this.getTileEntitySafe(world, pos), te -> FuncUtil.runIf(te.getColor(), color -> (Boolean)PersonalConfig.candyColors.get() != false ? color.func_193350_e() : MapColor.func_193558_a((EnumDyeColor)color).field_76291_p, -1), -1) : -1;
    }

    public void func_180649_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        if (player.func_70093_af()) {
            FuncUtil.doIf(DyeColor.getColorFromDye((ItemStack)player.func_184614_ca()), col -> FuncUtil.doIf(this.getTileEntitySafe((IBlockAccess)world, pos), te -> te.setColor(EnumDyeColor.func_176766_a((int)col.ordinal()))));
        }
        super.func_180649_a(world, pos, player);
    }
}

