/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.invpanel;

import com.enderio.core.client.gui.GhostSlotHandler;
import com.enderio.core.client.gui.widget.GhostBackgroundItemSlot;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.util.ItemUtil;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.invpanel.database.IChangeLog;
import crazypants.enderio.base.invpanel.database.IInventoryDatabaseServer;
import crazypants.enderio.base.invpanel.database.IInventoryPanel;
import crazypants.enderio.base.invpanel.database.IServerItemEntry;
import crazypants.enderio.base.machine.gui.AbstractMachineContainer;
import crazypants.enderio.invpanel.invpanel.InventoryCraftingWrapper;
import crazypants.enderio.invpanel.invpanel.TileInventoryPanel;
import crazypants.enderio.invpanel.network.PacketHandler;
import crazypants.enderio.invpanel.network.PacketItemList;
import crazypants.enderio.invpanel.network.PacketMoveItems;
import crazypants.enderio.invpanel.remote.ItemRemoteInvAccess;
import crazypants.enderio.invpanel.util.SlotCraftingWrapper;
import crazypants.enderio.invpanel.util.StoredCraftingRecipe;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class InventoryPanelContainer
extends AbstractMachineContainer<TileInventoryPanel>
implements IChangeLog {
    public static int FIRST_RECIPE_SLOT = 1;
    public static int NUM_RECIPE_SLOT = 9;
    public static int FIRST_INVENTORY_SLOT = 11;
    public static int NUM_INVENTORY_SLOT = 46;
    public static final int CRAFTING_GRID_X = 7;
    public static final int CRAFTING_GRID_Y = 16;
    public static final int RETURN_INV_X = 7;
    public static final int RETURN_INV_Y = 82;
    public static final int FILTER_SLOT_X = 233;
    public static final int FILTER_SLOT_Y = 7;
    private final HashSet<IServerItemEntry> changedItems;
    private Slot slotFilter;
    private int slotCraftResult;
    private int firstSlotReturn;
    private int endSlotReturn;
    private int firstSlotCraftingGrid;
    private int endSlotCraftingGrid;
    private boolean updateReturnAreaSlots;
    private boolean storedRecipeExists;
    @Nonnull
    private final World playerWorld;
    private SlotCraftingWrapper slotCraft;

    public InventoryPanelContainer(@Nonnull InventoryPlayer playerInv, @Nonnull TileInventoryPanel te) {
        super(playerInv, te);
        te.eventHandler = this;
        this.playerWorld = playerInv.field_70458_d.field_70170_p;
        this.changedItems = !te.func_145830_o() || te.func_145831_w().field_72995_K ? null : new HashSet();
        this.slotCraft.field_75224_c = te;
    }

    @Override
    protected void addMachineSlots(@Nonnull InventoryPlayer playerInv) {
        int x;
        int y;
        this.slotCraftResult = this.field_75151_b.size();
        this.slotCraft = new SlotCraftingWrapper(playerInv.field_70458_d, new InventoryCraftingWrapper(this.getInv(), (Container)this, 3, 3), this.getInv(), 9, 66, 34);
        this.func_75146_a((Slot)this.slotCraft);
        this.firstSlotCraftingGrid = this.field_75151_b.size();
        int i = 0;
        for (y = 0; y < 3; ++y) {
            x = 0;
            while (x < 3) {
                this.func_75146_a(new Slot(this.getInv(), i, 7 + x * 18, 16 + y * 18));
                ++x;
                ++i;
            }
        }
        this.endSlotCraftingGrid = this.field_75151_b.size();
        this.slotFilter = this.func_75146_a(new Slot(this.getInv(), 10, 233, 7){

            public int func_75219_a() {
                return 1;
            }
        });
        this.firstSlotReturn = this.field_75151_b.size();
        i = 11;
        for (y = 0; y < 3; ++y) {
            x = 0;
            while (x < 5) {
                this.func_75146_a(new Slot(this.getInv(), i, 7 + x * 18, 82 + y * 18));
                ++x;
                ++i;
            }
        }
        this.endSlotReturn = this.field_75151_b.size();
    }

    public void createGhostSlots(GhostSlotHandler slots) {
        slots.add((GhostSlot)new GhostBackgroundItemSlot(ModObject.itemBasicItemFilter.getItemNN(), 233, 7));
    }

    @Override
    @Nonnull
    public Point getPlayerInventoryOffset() {
        return new Point(39, 148);
    }

    public void func_75134_a(@Nonnull EntityPlayer player) {
        super.func_75134_a(player);
        if (((TileInventoryPanel)this.getTe()).func_145830_o() && !((TileInventoryPanel)this.getTe()).func_145831_w().field_72995_K) {
            ((TileInventoryPanel)this.getTe()).eventHandler = null;
        }
        this.removeChangeLog();
    }

    public Slot getSlotFilter() {
        return this.slotFilter;
    }

    public List<Slot> getCraftingGridSlots() {
        return this.field_75151_b.subList(this.firstSlotCraftingGrid, this.endSlotCraftingGrid);
    }

    public List<Slot> getReturnAreaSlots() {
        return this.field_75151_b.subList(this.firstSlotReturn, this.endSlotReturn);
    }

    public List<Slot> getPlayerInventorySlots() {
        return this.field_75151_b.subList(this.startPlayerSlot, this.endPlayerSlot);
    }

    public List<Slot> getPlayerHotbarSlots() {
        return this.field_75151_b.subList(this.startHotBarSlot, this.endHotBarSlot);
    }

    private void removeChangeLog() {
        IInventoryDatabaseServer db;
        if (this.changedItems != null && (db = ((TileInventoryPanel)this.getTe()).getDatabaseServer()) != null) {
            db.removeChangeLog(this);
        }
    }

    public void func_82847_b(@Nonnull IContainerListener crafting) {
        super.func_82847_b(crafting);
        this.removeChangeLog();
    }

    public void func_75132_a(@Nonnull IContainerListener crafting) {
        IInventoryDatabaseServer db;
        if (this.changedItems != null) {
            this.sendChangeLog();
        }
        super.func_75132_a(crafting);
        if (this.changedItems != null && (db = ((TileInventoryPanel)this.getTe()).getDatabaseServer()) != null) {
            db.addChangeLog(this);
            if (crafting instanceof EntityPlayerMP) {
                try {
                    byte[] compressed = db.compressItemList();
                    PacketItemList pil = new PacketItemList(this.field_75152_c, db.getGeneration(), compressed);
                    PacketHandler.sendTo(pil, (EntityPlayerMP)crafting);
                }
                catch (IOException ex) {
                    Logger.getLogger(InventoryPanelContainer.class.getName()).log(Level.SEVERE, "Exception while compressing item list", ex);
                }
            }
        }
    }

    public void func_75130_a(@Nonnull IInventory inv) {
        InventoryCrafting tmp = new InventoryCrafting(new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer ep) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            tmp.func_70299_a(i, ((TileInventoryPanel)this.getTe()).getStackInSlot(i));
        }
        ((TileInventoryPanel)this.getTe()).setInventorySlotContents(9, CraftingManager.func_82787_a((InventoryCrafting)tmp, (World)this.playerWorld));
        this.checkCraftingRecipes();
    }

    public void checkCraftingRecipes() {
        this.storedRecipeExists = false;
        int storedCraftingRecipes = ((TileInventoryPanel)this.getTe()).getStoredCraftingRecipes();
        if (this.hasCraftingRecipe() && storedCraftingRecipes > 0) {
            List<Slot> craftingGrid = this.getCraftingGridSlots();
            for (int idx = 0; idx < storedCraftingRecipes; ++idx) {
                StoredCraftingRecipe recipe = ((TileInventoryPanel)this.getTe()).getStoredCraftingRecipe(idx);
                if (recipe == null || !recipe.isEqual(craftingGrid)) continue;
                this.storedRecipeExists = true;
                break;
            }
        }
    }

    public boolean func_94530_a(@Nonnull ItemStack par1, @Nonnull Slot slot) {
        return !(slot instanceof SlotCrafting) && super.func_94530_a(par1, slot);
    }

    public boolean clearCraftingGrid() {
        boolean cleared = true;
        for (Slot slot : this.getCraftingGridSlots()) {
            if (!slot.func_75216_d()) continue;
            this.moveItemsToReturnArea(slot.field_75222_d);
            if (!slot.func_75216_d()) continue;
            cleared = false;
        }
        return cleared;
    }

    public boolean hasCraftingRecipe() {
        return this.func_75139_a(this.slotCraftResult).func_75216_d();
    }

    public boolean hasNewCraftingRecipe() {
        return this.hasCraftingRecipe() && !this.storedRecipeExists;
    }

    @Override
    @Nonnull
    protected List<AbstractMachineContainer.SlotRange> getTargetSlotsForTransfer(int slotIndex, @Nonnull Slot slot) {
        if (slotIndex == this.slotCraftResult || slotIndex >= this.firstSlotReturn && slotIndex < this.endSlotReturn) {
            return Collections.singletonList(this.getPlayerInventorySlotRange(true));
        }
        if (slotIndex >= this.firstSlotCraftingGrid && slotIndex < this.endSlotCraftingGrid) {
            ArrayList<AbstractMachineContainer.SlotRange> res = new ArrayList<AbstractMachineContainer.SlotRange>();
            res.add(new AbstractMachineContainer.SlotRange(this.firstSlotReturn, this.endSlotReturn, false));
            res.add(this.getPlayerInventorySlotRange(false));
            return res;
        }
        if (slotIndex >= this.startPlayerSlot) {
            return Collections.singletonList(new AbstractMachineContainer.SlotRange(this.firstSlotReturn, this.endSlotReturn, false));
        }
        return Collections.emptyList();
    }

    protected boolean func_75135_a(@Nonnull ItemStack par1ItemStack, int fromIndex, int toIndex, boolean reversOrder) {
        if (!super.func_75135_a(par1ItemStack, fromIndex, toIndex, reversOrder)) {
            return false;
        }
        if (fromIndex < this.endSlotReturn && toIndex > this.firstSlotReturn) {
            this.updateReturnAreaSlots = true;
        }
        return true;
    }

    @Override
    public void func_75142_b() {
        if (this.updateReturnAreaSlots) {
            this.updateReturnAreaSlots = false;
            this.sendReturnAreaSlots();
        }
        super.func_75142_b();
    }

    private void sendReturnAreaSlots() {
        for (int slotIdx = this.firstSlotReturn; slotIdx < this.endSlotReturn; ++slotIdx) {
            ItemStack stack = ((Slot)this.field_75151_b.get(slotIdx)).func_75211_c();
            if (!stack.func_190926_b()) {
                stack = stack.func_77946_l();
            }
            this.field_75153_a.set(slotIdx, (Object)stack);
            for (IContainerListener crafter : this.field_75149_d) {
                crafter.func_71111_a((Container)this, slotIdx, stack);
            }
        }
    }

    @Override
    public void entryChanged(IServerItemEntry entry) {
        this.changedItems.add(entry);
    }

    @Override
    public void databaseReset() {
        this.changedItems.clear();
    }

    @Override
    public void sendChangeLog() {
        IInventoryDatabaseServer db;
        if (!this.changedItems.isEmpty() && !this.field_75149_d.isEmpty() && (db = ((TileInventoryPanel)this.getTe()).getDatabaseServer()) != null) {
            try {
                byte[] compressed = db.compressChangedItems(this.changedItems);
                PacketItemList pil = new PacketItemList(this.field_75152_c, db.getGeneration(), compressed);
                for (Object crafting : this.field_75149_d) {
                    if (!(crafting instanceof EntityPlayerMP)) continue;
                    PacketHandler.sendTo(pil, (EntityPlayerMP)crafting);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(InventoryPanelContainer.class.getName()).log(Level.SEVERE, "Exception while compressing changed items", ex);
            }
        }
        this.changedItems.clear();
    }

    public int getSlotIndex(@Nonnull IInventory inv, int index) {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!slot.func_75217_a(inv, index)) continue;
            return i;
        }
        return -1;
    }

    public void executeFetchItems(EntityPlayerMP player, int generation, int dbID, int targetSlot, int count) {
        IInventoryDatabaseServer db = ((TileInventoryPanel)this.te).getDatabaseServer();
        if (db == null || db.getGeneration() != generation || !db.isCurrent()) {
            return;
        }
        IServerItemEntry entry = (IServerItemEntry)db.getExistingItem(dbID);
        if (entry != null) {
            int extracted;
            int maxStackSize;
            ItemStack targetStack;
            Slot slot;
            if (targetSlot < 0) {
                slot = null;
                targetStack = player.field_71071_by.func_70445_o();
                maxStackSize = player.field_71071_by.func_70297_j_();
            } else {
                slot = this.func_75139_a(targetSlot);
                targetStack = slot.func_75211_c();
                maxStackSize = slot.func_75219_a();
            }
            ItemStack tmpStack = new ItemStack(entry.getItem(), 1, entry.getMeta());
            tmpStack.func_77982_d(entry.getNbt());
            maxStackSize = Math.min(maxStackSize, tmpStack.func_77976_d());
            if (!targetStack.func_190926_b() && targetStack.func_190916_E() > 0) {
                if (!ItemUtil.areStackMergable((ItemStack)tmpStack, (ItemStack)targetStack)) {
                    return;
                }
            } else {
                targetStack = tmpStack.func_77946_l();
            }
            if ((count = Math.min(count, maxStackSize)) > 0 && (extracted = db.extractItems(entry, count, (IInventoryPanel)((Object)this.te))) > 0) {
                targetStack.func_190920_e(extracted);
                this.sendChangeLog();
                if (slot != null) {
                    slot.func_75215_d(targetStack);
                } else {
                    player.field_71071_by.func_70437_b(targetStack);
                    player.func_71113_k();
                }
            }
        }
        this.func_75142_b();
    }

    public boolean moveItemsToReturnArea(int fromSlot) {
        return this.moveItems(fromSlot, this.firstSlotReturn, this.endSlotReturn, Short.MAX_VALUE);
    }

    public boolean moveItems(int fromSlot, int toSlotStart, int toSlotEnd, int amount) {
        if (!this.executeMoveItems(fromSlot, toSlotStart, toSlotEnd, amount)) {
            return false;
        }
        if (!((TileInventoryPanel)this.getTe()).func_145830_o() || ((TileInventoryPanel)this.getTe()).func_145831_w().field_72995_K) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketMoveItems(fromSlot, toSlotStart, toSlotEnd, amount));
        }
        return true;
    }

    public boolean executeMoveItems(int fromSlot, int toSlotStart, int toSlotEnd, int amount) {
        if (fromSlot >= toSlotStart && fromSlot < toSlotEnd || toSlotEnd <= toSlotStart || amount <= 0) {
            return false;
        }
        Slot srcSlot = this.func_75139_a(fromSlot);
        ItemStack src = srcSlot.func_75211_c();
        if (!src.func_190926_b()) {
            ItemStack toMove = src.func_77946_l();
            toMove.func_190920_e(Math.min(src.func_190916_E(), amount));
            int remaining = src.func_190916_E() - toMove.func_190916_E();
            if (this.func_75135_a(toMove, toSlotStart, toSlotEnd, false)) {
                if ((remaining += toMove.func_190916_E()) == 0) {
                    srcSlot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    src.func_190920_e(remaining);
                    srcSlot.func_75218_e();
                }
                return true;
            }
        }
        return false;
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        if (super.func_75145_c(player)) {
            return true;
        }
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemRemoteInvAccess) {
            if (!player.func_130014_f_().field_72995_K) {
                return ((ItemRemoteInvAccess)player.func_184614_ca().func_77973_b()).canInteractWith(player.func_184614_ca(), player);
            }
            return true;
        }
        if (!player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof ItemRemoteInvAccess) {
            if (!player.func_130014_f_().field_72995_K) {
                return ((ItemRemoteInvAccess)player.func_184592_cb().func_77973_b()).canInteractWith(player.func_184592_cb(), player);
            }
            return true;
        }
        return false;
    }

    public void tick(@Nonnull EntityPlayer player) {
        if (!super.func_75145_c(player)) {
            if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemRemoteInvAccess) {
                ((ItemRemoteInvAccess)player.func_184614_ca().func_77973_b()).tick(player.func_184614_ca(), player);
            } else if (!player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof ItemRemoteInvAccess) {
                ((ItemRemoteInvAccess)player.func_184592_cb().func_77973_b()).tick(player.func_184592_cb(), player);
            }
        }
    }
}

