/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.server;

import crazypants.enderio.base.invpanel.database.AbstractInventory;
import crazypants.enderio.base.invpanel.database.IInventoryDatabaseServer;
import crazypants.enderio.base.invpanel.database.IServerItemEntry;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;

class NormalInventory
extends AbstractInventory {
    final IItemHandler inv;
    final BlockPos pos;

    NormalInventory(@Nonnull IItemHandler inv, @Nonnull BlockPos pos) {
        this.inv = inv;
        this.pos = pos;
    }

    @Override
    public int scanInventory(@Nonnull IInventoryDatabaseServer db) {
        if (this.inv == null) {
            this.setEmpty(db);
            return 0;
        }
        int numSlots = this.inv.getSlots();
        if (numSlots < 1) {
            this.setEmpty(db);
            return 0;
        }
        if (numSlots != this.slotKeys.length) {
            this.reset(db, numSlots);
        }
        for (int slot = 0; slot < numSlots; ++slot) {
            ItemStack stack = this.inv.getStackInSlot(slot);
            if (!stack.func_190926_b()) {
                if (stack.func_190916_E() == 0) {
                    stack = ItemStack.field_190927_a;
                } else {
                    ItemStack extracted = this.inv.extractItem(slot, stack.func_190916_E(), true);
                    if (extracted.func_190926_b()) {
                        stack = ItemStack.field_190927_a;
                    } else if (stack.func_190916_E() > stack.func_77976_d()) {
                        if (extracted.func_190916_E() < stack.func_77976_d()) {
                            stack = ItemStack.field_190927_a;
                        }
                    } else if (extracted.func_190916_E() != stack.func_190916_E()) {
                        stack = ItemStack.field_190927_a;
                    }
                }
            }
            this.updateSlot(db, slot, stack);
        }
        return numSlots;
    }

    @Override
    public int extractItem(@Nonnull IInventoryDatabaseServer db, IServerItemEntry entry, int slot, int count) {
        if (this.inv == null) {
            return 0;
        }
        ItemStack stack = this.inv.getStackInSlot(slot);
        if (stack.func_190926_b() || stack.func_190916_E() == 0 || db.lookupItem(stack, entry, false) != entry) {
            return 0;
        }
        ItemStack extracted = this.inv.extractItem(slot, count, false);
        if (extracted.func_190926_b() || extracted.func_190916_E() == 0) {
            return 0;
        }
        stack = this.inv.getStackInSlot(slot);
        if (!stack.func_190926_b()) {
            this.updateCount(db, slot, entry, stack.func_190916_E());
        } else {
            this.updateCount(db, slot, entry, 0);
        }
        return extracted.func_190916_E();
    }

    @Override
    public void markForScanning(@Nonnull BlockPos posIn) {
        if (this.pos.equals((Object)posIn)) {
            this.markForScanning();
        }
    }
}

