/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.obelisk.xp;

import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.xp.PacketExperienceContainer;
import crazypants.enderio.base.xp.XpUtil;
import crazypants.enderio.machines.machine.obelisk.xp.TileExperienceObelisk;
import crazypants.enderio.machines.network.PacketHandler;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerExperienceObelisk
extends Container {
    public static final int ADD_XP = 42;
    public static final int DWN_XP = 43;
    public static final int REM_XP = 44;
    @Nonnull
    private final TileExperienceObelisk inv;
    @Nonnull
    private final EntityPlayer player;

    public ContainerExperienceObelisk(@Nonnull EntityPlayer player, @Nonnull TileExperienceObelisk inv) {
        this.inv = inv;
        this.player = player;
    }

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return this.inv.isUseableByPlayer(playerIn);
    }

    public void doAddXP(int levels) {
        try {
            if (this.player.field_71075_bZ.field_75098_d) {
                int containerLevel = this.inv.getContainer().getExperienceLevel();
                int targetLevel = Math.max(0, containerLevel - levels);
                int diffxp = XpUtil.getExperienceForLevel(containerLevel) - XpUtil.getExperienceForLevel(targetLevel);
                this.inv.getContainer().removeExperience(diffxp);
                XpUtil.addPlayerXP(this.player, diffxp);
            } else {
                this.inv.getContainer().givePlayerXp(this.player, MathHelper.func_76125_a((int)levels, (int)0, (int)10000));
            }
        }
        catch (XpUtil.TooManyXPLevelsException e) {
            this.player.func_146105_b((ITextComponent)Lang.GUI_TOO_MANY_LEVELS.toChatServer(), true);
        }
        PacketHandler.sendToAllAround((IMessage)new PacketExperienceContainer((TileEntity)this.inv), (TileEntity)this.inv);
    }

    public void doDrainXP(int levels) {
        if (this.player.field_71075_bZ.field_75098_d) {
            int containerLevel = this.inv.getContainer().getExperienceLevel();
            int targetLevel = Math.min(containerLevel + levels, XpUtil.getLevelForExperience(this.inv.getContainer().getMaximumExperience()));
            int diffxp = XpUtil.getExperienceForLevel(targetLevel) - XpUtil.getExperienceForLevel(containerLevel);
            this.inv.getContainer().addExperience(diffxp);
        } else {
            try {
                int level = MathHelper.func_76125_a((int)(Minecraft.func_71410_x().field_71439_g.field_71068_ca - levels), (int)0, (int)Minecraft.func_71410_x().field_71439_g.field_71068_ca);
                this.inv.getContainer().drainPlayerXpToReachPlayerLevel(this.player, level);
            }
            catch (XpUtil.TooManyXPLevelsException e) {
                this.player.func_146105_b((ITextComponent)Lang.GUI_TOO_MANY_LEVELS.toChatServer(), true);
            }
        }
        PacketHandler.sendToAllAround((IMessage)new PacketExperienceContainer((TileEntity)this.inv), (TileEntity)this.inv);
    }
}

