/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pcl.opensecurity.Config;
import pcl.opensecurity.common.CommonProxy;
import pcl.opensecurity.common.ContentRegistry;
import pcl.opensecurity.common.SoundHandler;
import pcl.opensecurity.common.blocks.BlockNanoFog;
import pcl.opensecurity.common.tileentity.TileEntityAlarm;
import pcl.opensecurity.manual.Manual;
import pcl.opensecurity.networking.HandlerKeypadButton;
import pcl.opensecurity.networking.PacketKeypadButton;
import pcl.opensecurity.networking.PacketProtectionAdd;
import pcl.opensecurity.networking.PacketProtectionRemove;
import pcl.opensecurity.networking.PacketProtectionSync;
import zmaster587.advancedRocketry.api.AdvancedRocketryAPI;

@Mod.EventBusSubscriber
@Mod(modid="opensecurity", name="OpenSecurity", version="1.0-83", dependencies="required-after:opencomputers;after:rtfm;after:galacticraftcore", updateJSON="http://modupdates.pc-logix.com/opensecurity", guiFactory="pcl.opensecurity.client.config.ConfigGUI", acceptedMinecraftVersions="[1.12.2]")
public class OpenSecurity {
    public static final String MODID = "opensecurity";
    @Mod.Instance(value="opensecurity")
    public static OpenSecurity instance;
    @SidedProxy(clientSide="pcl.opensecurity.client.ClientProxy", serverSide="pcl.opensecurity.common.CommonProxy")
    public static CommonProxy proxy;
    public static final String GUIFACTORY = "pcl.opensecurity.client.config.ConfigGUI";
    public static final String ASSETSPATH = "mods/OpenSecurity/assets/opensecurity";
    public static boolean debug;
    public static int rfidRange;
    public static int entityDetectorMaxRange;
    public static boolean ignoreUUIDs;
    public static boolean registerBlockBreakEvent;
    public static HashSet<String> alarmList;
    public static boolean advancedRocketry;
    public static final Logger logger;
    public static SimpleNetworkWrapper network;
    public static ContentRegistry contentRegistry;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        long time = System.nanoTime();
        advancedRocketry = Loader.isModLoaded((String)"advancedrocketry");
        Config.preInit();
        Manual.preInit();
        registerBlockBreakEvent = Config.getConfig().getCategory("general").get("registerBlockBreak").getBoolean();
        rfidRange = Config.getConfig().getCategory("general").get("rfidMaxRange").getInt();
        entityDetectorMaxRange = Config.getConfig().getCategory("general").get("entityDetectorMaxRange").getInt();
        debug = Config.getConfig().getCategory("general").get("enableDebugMessages").getBoolean();
        ContentRegistry.preInit();
        MinecraftForge.EVENT_BUS.register((Object)contentRegistry);
        proxy.registerSounds();
        SoundHandler.registerSounds();
        network = NetworkRegistry.INSTANCE.newSimpleChannel("OpenSecurity");
        TileEntityAlarm.volumeMax = Config.getConfig().getCategory("general").get("alarmMaxRange").getInt();
        proxy.preinit();
        int packetID = 0;
        network.registerMessage(HandlerKeypadButton.class, PacketKeypadButton.class, packetID++, Side.CLIENT);
        network.registerMessage(PacketProtectionAdd.Handler.class, PacketProtectionAdd.class, packetID++, Side.CLIENT);
        network.registerMessage(PacketProtectionRemove.Handler.class, PacketProtectionRemove.class, packetID++, Side.CLIENT);
        network.registerMessage(PacketProtectionSync.Handler.class, PacketProtectionSync.class, packetID++, Side.CLIENT);
        if (debug) {
            logger.info("Registered " + packetID + " packets");
            logger.info("Finished pre-init in %d ms", (Object)((System.nanoTime() - time) / 1000000L));
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        long time = System.nanoTime();
        proxy.init();
        ContentRegistry.init();
        if (advancedRocketry) {
            AdvancedRocketryAPI.atomsphereSealHandler.addSealableBlock((Block)BlockNanoFog.DEFAULTITEM);
            logger.info("NanoFog with AdvancedRocketry support");
        }
        if (debug) {
            logger.info("Finished init in %d ms", (Object)((System.nanoTime() - time) / 1000000L));
        }
    }

    @SubscribeEvent
    public static void onRegisterModels(ModelRegistryEvent event) {
        proxy.registerModels();
    }

    static {
        debug = false;
        ignoreUUIDs = false;
        registerBlockBreakEvent = true;
        alarmList = new HashSet();
        advancedRocketry = false;
        logger = LogManager.getFormatterLogger((String)MODID);
        contentRegistry = new ContentRegistry();
    }
}

