/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.client.renderer;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pcl.opensecurity.common.tileentity.TileEntitySecurityTerminal;

@SideOnly(value=Side.CLIENT)
public class SecurityTerminalRender {
    public static void showFoundTerminals(RenderWorldLastEvent evt) {
        HashMap<BlockPos, TileEntitySecurityTerminal> foundPositions = new HashMap<BlockPos, TileEntitySecurityTerminal>();
        for (TileEntity te : Minecraft.func_71410_x().field_71439_g.field_70170_p.field_147482_g) {
            if (te == null || !(te instanceof TileEntitySecurityTerminal)) continue;
            foundPositions.putIfAbsent(te.func_174877_v(), (TileEntitySecurityTerminal)te);
        }
        if (foundPositions.size() > 0) {
            SecurityTerminalRender.renderBlocks(evt, foundPositions);
        }
    }

    private static void renderBlocks(RenderWorldLastEvent evt, HashMap<BlockPos, TileEntitySecurityTerminal> blocks) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double doubleX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)evt.getPartialTicks();
        double doubleY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)evt.getPartialTicks();
        double doubleZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)evt.getPartialTicks();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        GlStateManager.func_179118_c();
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        for (Map.Entry<BlockPos, TileEntitySecurityTerminal> pos : blocks.entrySet()) {
            if (!pos.getValue().isParticleEnabled() || !pos.getValue().isEnabled() || !pos.getValue().getOwner().equals(player.func_110124_au()) && !pos.getValue().isUserAllowedToBypass(player.func_110124_au())) continue;
            SecurityTerminalRender.renderBoxOutline(pos.getKey(), pos.getValue());
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
    }

    private static void renderBoxOutline(BlockPos pos, TileEntitySecurityTerminal te) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float mx = pos.func_177958_n();
        float my = pos.func_177956_o();
        float mz = pos.func_177952_p();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        SecurityTerminalRender.renderHighLightedBlocksOutline(buffer, mx, my, mz, te.rangeMod * 8, 0.9f, 0.7f, 0.0f, 1.0f);
        tessellator.func_78381_a();
    }

    public static void renderHighLightedBlocksOutline(BufferBuilder buffer, float mx, float my, float mz, float range, float r, float g, float b, float a) {
        buffer.func_181662_b((double)(mx - range), (double)(my - range), (double)(mz - range)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + range + 1.0f), (double)(my - range), (double)(mz - range)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx - range), (double)(my - range), (double)(mz - range)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx - range), (double)(my + range + 1.0f), (double)(mz - range)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx - range), (double)(my - range), (double)(mz - range)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx - range), (double)(my - range), (double)(mz + range + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + range + 1.0f), (double)(my + range + 1.0f), (double)(mz + range + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx - range), (double)(my + range + 1.0f), (double)(mz + range + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + range + 1.0f), (double)(my + range + 1.0f), (double)(mz + range + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + range + 1.0f), (double)(my - range), (double)(mz + range + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + range + 1.0f), (double)(my + range + 1.0f), (double)(mz + range + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + range + 1.0f), (double)(my + range + 1.0f), (double)(mz - range)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx - range), (double)(my + range + 1.0f), (double)(mz - range)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx - range), (double)(my + range + 1.0f), (double)(mz + range + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx - range), (double)(my + range + 1.0f), (double)(mz - range)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + range + 1.0f), (double)(my + range + 1.0f), (double)(mz - range)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + range + 1.0f), (double)(my - range), (double)(mz - range)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + range + 1.0f), (double)(my - range), (double)(mz + range + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + range + 1.0f), (double)(my - range), (double)(mz - range)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + range + 1.0f), (double)(my + range + 1.0f), (double)(mz - range)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx - range), (double)(my - range), (double)(mz + range + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + range + 1.0f), (double)(my - range), (double)(mz + range + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx - range), (double)(my - range), (double)(mz + range + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx - range), (double)(my + range + 1.0f), (double)(mz + range + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
    }
}

