/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.blocks;

import java.util.Comparator;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import pcl.opensecurity.common.ContentRegistry;
import pcl.opensecurity.common.interfaces.IOwner;
import pcl.opensecurity.common.interfaces.IVariant;
import pcl.opensecurity.common.items.ItemMagCard;
import pcl.opensecurity.common.tileentity.TileEntityMagReader;

public class BlockMagReader
extends Block
implements ITileEntityProvider {
    public static final String NAME = "mag_reader";
    public static Block DEFAULTITEM;
    public static final IProperty<EnumType> VARIANT;

    public BlockMagReader() {
        super(Material.field_151573_f);
        this.func_149663_c("opensecurity.mag_reader");
        this.setRegistryName("opensecurity", NAME);
        this.func_149711_c(0.5f);
        this.func_149647_a(ContentRegistry.creativeTab);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity te = worldIn.func_175625_s(pos);
        ((IOwner)te).setOwner(placer.func_110124_au());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return super.getPickBlock(this.func_176223_P(), target, world, pos, player);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMeta();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMagReader();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem;
        world.func_180497_b(pos, (Block)this, 20, 1);
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemMagCard) {
            heldItem = player.func_184614_ca();
        } else if (!player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof ItemMagCard) {
            heldItem = player.func_184592_cb();
        } else {
            return false;
        }
        if (!heldItem.func_190926_b()) {
            System.out.println(heldItem.func_77973_b().getRegistryName().toString());
            Item equipped = heldItem.func_77973_b();
            TileEntityMagReader tile = (TileEntityMagReader)world.func_175625_s(pos);
            if (!world.field_72995_K && equipped instanceof ItemMagCard) {
                world.func_175656_a(pos, state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.ACTIVE)));
                if (tile.doRead(heldItem, player, side)) {
                    world.func_175656_a(pos, state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.SUCCESS)));
                } else {
                    world.func_175656_a(pos, state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.ERROR)));
                }
            }
            return true;
        }
        return false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        worldIn.func_175656_a(pos, state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.IDLE)));
    }

    static {
        VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    }

    public static enum EnumType implements IVariant
    {
        IDLE(0, "idle"),
        ACTIVE(1, "active"),
        SUCCESS(2, "success"),
        ERROR(3, "error");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        @Override
        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public static String[] getNames() {
            return (String[])Stream.of(META_LOOKUP).map(EnumType::func_176610_l).toArray(String[]::new);
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

