/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.interfaces;

import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public interface ICamo {
    public IBlockState getCamoBlock();

    public void setCamoBlock(Block var1, int var2);

    default public boolean setCamoBlock(EntityPlayer player, ItemStack stack) {
        return this.playerCanChangeCamo(player) && this.setCamoBlock(stack);
    }

    default public boolean setCamoBlock(ItemStack stack) {
        if (!this.isValidCamoBlock(stack)) {
            return false;
        }
        this.setCamoBlock(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j());
        return true;
    }

    default public boolean playerCanChangeCamo(EntityPlayer player) {
        return true;
    }

    default public boolean isValidCamoBlock(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (!(stack.func_77973_b() instanceof ItemBlock)) {
            return false;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block.func_149686_d(block.func_176223_P())) {
            return true;
        }
        return block instanceof BlockGlass || block instanceof BlockStainedGlass;
    }

    public static class MimicBlock {
        private IBlockState mimic = null;
        public int camoId = -1;
        public int camoMeta = 0;

        public IBlockState get() {
            return this.mimic != null ? this.mimic : Blocks.field_150350_a.func_176223_P();
        }

        @Deprecated
        public void set(Block block, int meta) {
            this.camoId = Block.func_149682_b((Block)block);
            this.camoMeta = meta;
            this.mimic = this.camoId != -1 ? Block.func_149729_e((int)this.camoId).func_176203_a(meta) : null;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("id", this.camoId);
            nbt.func_74768_a("meta", this.camoMeta);
            return nbt;
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.camoId = nbt.func_74762_e("id");
            this.camoMeta = nbt.func_74762_e("meta");
            this.mimic = this.camoId != -1 ? Block.func_149729_e((int)this.camoId).func_176203_a(this.camoMeta) : null;
        }
    }
}

