/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.items;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.common.items.ItemOSBase;

public abstract class ItemCard
extends ItemOSBase {
    ItemCard(String name) {
        super(name);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.SUCCESS;
    }

    public static class CardTag {
        public boolean locked = false;
        public String localUUID = UUID.randomUUID().toString();
        public String dataTag = "";
        public int color = 0xFFFFFF;
        public boolean isValid;

        public CardTag(ItemStack stack) {
            if (stack.func_77973_b() instanceof ItemCard) {
                this.readFromNBT(stack.func_77978_p());
            }
        }

        public CardTag(NBTTagCompound nbt) {
            this.readFromNBT(nbt);
        }

        public void readFromNBT(NBTTagCompound nbt) {
            if (nbt != null) {
                NBTTagCompound displayTag;
                if (nbt.func_74764_b("uuid")) {
                    String string = this.localUUID = OpenSecurity.ignoreUUIDs ? "-1" : nbt.func_74779_i("uuid");
                }
                if (nbt.func_74764_b("data")) {
                    this.dataTag = nbt.func_74779_i("data");
                }
                if (nbt.func_74764_b("locked")) {
                    this.locked = nbt.func_74767_n("locked");
                }
                if (nbt.func_150297_b("display", 10) && (displayTag = nbt.func_74775_l("display")).func_150297_b("color", 3)) {
                    this.color = displayTag.func_74762_e("color");
                }
            }
            this.isValid = this.dataTag.length() > 0;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.func_74778_a("data", this.dataTag);
            nbt.func_74778_a("uuid", this.localUUID);
            nbt.func_74757_a("locked", this.locked);
            NBTTagCompound displayTag = new NBTTagCompound();
            displayTag.func_74768_a("color", this.color);
            nbt.func_74782_a("display", (NBTBase)displayTag);
            return nbt;
        }
    }
}

