/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.util;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FilenameUtils;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.util.FileUtils;

public class ServerResourcePackFactory {
    public static ServerResourcePackFactory FACTORY = new ServerResourcePackFactory();

    public void create(String resourcePackName, String sourcePath, String targetPath) {
        File input = new File(this.getDataDirectory() + sourcePath);
        File outputDirectory = new File(this.getDataDirectory() + "server-resource-packs");
        outputDirectory.mkdirs();
        File outputFile = new File(outputDirectory + "/" + resourcePackName + ".zip");
        try {
            ZipArchiveOutputStream zip = new ZipArchiveOutputStream(outputFile);
            for (File fileName : FileUtils.listFilesForPath(input.getPath())) {
                String relativePath = FilenameUtils.getPath((String)fileName.getPath()).replaceFirst(input.getPath(), "");
                ZipArchiveEntry entry = new ZipArchiveEntry(targetPath + relativePath + fileName.getName());
                zip.putArchiveEntry((ArchiveEntry)entry);
                zip.write(org.apache.commons.io.FileUtils.readFileToByteArray((File)fileName));
                zip.closeArchiveEntry();
            }
            ZipArchiveEntry entry = new ZipArchiveEntry("pack.mcmeta");
            zip.putArchiveEntry((ArchiveEntry)entry);
            zip.write(this.createMcMeta());
            zip.closeArchiveEntry();
            zip.close();
        }
        catch (Exception e) {
            OpenSecurity.logger.warn("couldnt create server resource pack");
        }
    }

    private String getDataDirectory() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_71238_n().getPath();
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            Minecraft.func_71410_x().field_71412_D.getPath();
        }
        return "";
    }

    private byte[] createMcMeta() {
        String data = "{ \"pack\": { \"pack_format\": 2, \"description\": \"OpenSecurity custom sounds\" } }";
        return data.getBytes();
    }
}

