/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.init.Blocks;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.IChunkGenerator;

public class OreHelper {
    int minHeight;
    int maxHeight;
    int size;
    int count;

    public OreHelper(int minHeight, int maxHeight, int size, int count) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.size = size;
        this.count = count;
    }

    public OreHelper(ByteBuf buf) {
        this.minHeight = buf.readInt();
        this.maxHeight = buf.readInt();
        this.size = buf.readInt();
        this.count = buf.readInt();
    }

    public String getDescription() {
        return String.format("height %d-%d, size %d, count %d", this.minHeight, this.maxHeight, this.size, this.count);
    }

    public static String getId(Block block, int meta) {
        return String.format("#%04d/%d", Block.func_149682_b((Block)block), meta);
    }

    public static void initList(WorldServer[] worlds) {
        EnergyControl.oreHelper = new HashMap<String, OreHelper>();
        for (int i = 0; i < worlds.length; ++i) {
            IChunkGenerator generator = worlds[i].field_73011_w.func_186060_c();
            if (!(generator instanceof ChunkGeneratorOverworld)) continue;
            try {
                Field field = ChunkGeneratorOverworld.class.getDeclaredField("settings");
                field.setAccessible(true);
                ChunkGeneratorSettings over = (ChunkGeneratorSettings)field.get(generator);
                EnergyControl.oreHelper.put(OreHelper.getId(Blocks.field_150351_n, 0), new OreHelper(over.field_177787_O, over.field_177797_P, over.field_177785_M, over.field_177786_N));
                EnergyControl.oreHelper.put(OreHelper.getId(Blocks.field_150348_b, BlockStone.EnumType.GRANITE.ordinal()), new OreHelper(over.field_177798_S, over.field_177793_T, over.field_177796_Q, over.field_177799_R));
                EnergyControl.oreHelper.put(OreHelper.getId(Blocks.field_150348_b, BlockStone.EnumType.DIORITE.ordinal()), new OreHelper(over.field_177794_W, over.field_177801_X, over.field_177792_U, over.field_177795_V));
                EnergyControl.oreHelper.put(OreHelper.getId(Blocks.field_150348_b, BlockStone.EnumType.ANDESITE.ordinal()), new OreHelper(over.field_177846_aa, over.field_177847_ab, over.field_177800_Y, over.field_177802_Z));
                EnergyControl.oreHelper.put(OreHelper.getId(Blocks.field_150365_q, 0), new OreHelper(over.field_177851_ae, over.field_177853_af, over.field_177844_ac, over.field_177845_ad));
                EnergyControl.oreHelper.put(OreHelper.getId(Blocks.field_150366_p, 0), new OreHelper(over.field_177832_ai, over.field_177834_aj, over.field_177848_ag, over.field_177849_ah));
                EnergyControl.oreHelper.put(OreHelper.getId(Blocks.field_150352_o, 0), new OreHelper(over.field_177840_am, over.field_177842_an, over.field_177828_ak, over.field_177830_al));
                EnergyControl.oreHelper.put(OreHelper.getId(Blocks.field_150450_ax, 0), new OreHelper(over.field_177818_aq, over.field_177816_ar, over.field_177836_ao, over.field_177838_ap));
                EnergyControl.oreHelper.put(OreHelper.getId(Blocks.field_150482_ag, 0), new OreHelper(over.field_177826_au, over.field_177824_av, over.field_177814_as, over.field_177812_at));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            CrossModLoader.nuclearCraft.loadOreInfo();
            CrossModLoader.ic2.loadOreInfo();
        }
    }

    public void writeToBuf(ByteBuf buf) {
        buf.writeInt(this.minHeight);
        buf.writeInt(this.maxHeight);
        buf.writeInt(this.size);
        buf.writeInt(this.count);
    }
}

