/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.api.ItemStackHelper;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Loader;

public class CrossModLoader {
    public static CrossModBase ic2;
    public static CrossModBase techReborn;
    public static CrossModBase appEng;
    public static CrossModBase bigReactors;
    public static CrossModBase buildCraft;
    public static CrossModBase computerCraft;
    public static CrossModBase draconic;
    public static CrossModBase galacticraft;
    public static CrossModBase mekanism;
    public static CrossModBase openComputers;
    public static CrossModBase nuclearCraft;
    public static CrossModBase thermalExpansion;

    public static void init() {
        ic2 = CrossModLoader.findMod("ic2-classic-spmod", "CrossIC2Classic", "ic2", "CrossIC2Exp");
        techReborn = CrossModLoader.findMod("techreborn", "CrossTechReborn");
        appEng = CrossModLoader.findMod("appliedenergistics2", "CrossAppEng");
        bigReactors = CrossModLoader.findMod("bigreactors", "CrossBigReactors");
        buildCraft = CrossModLoader.findMod("buildcraftcore", "CrossBuildCraft");
        draconic = CrossModLoader.findMod("draconicevolution", "CrossDraconicEvolution");
        galacticraft = CrossModLoader.findMod("galacticraftplanets", "CrossGalacticraft");
        mekanism = CrossModLoader.findMod("mekanismgenerators", "CrossMekanism");
        nuclearCraft = CrossModLoader.findMod("nuclearcraft", "CrossNuclearCraft");
        computerCraft = CrossModLoader.findMod("computercraft", "computercraft.CrossComputerCraft");
        thermalExpansion = CrossModLoader.findMod("thermalexpansion", "CrossThermalExpansion");
    }

    public static void postInit() {
        openComputers = CrossModLoader.findMod("opencomputers", "opencomputers.CrossOpenComputers");
    }

    public static CrossModBase findMod(String modId, String mainClass) {
        return CrossModLoader.findMod(modId, mainClass, "", "");
    }

    public static CrossModBase findMod(String modId, String mainClass, String modId2, String mainClass2) {
        try {
            Class<?> clz;
            if (Loader.isModLoaded((String)modId) && (clz = Class.forName("com.zuxelus.energycontrol.crossmod." + mainClass)) != null) {
                return (CrossModBase)clz.newInstance();
            }
            if (Loader.isModLoaded((String)modId2) && (clz = Class.forName("com.zuxelus.energycontrol.crossmod." + mainClass2)) != null) {
                return (CrossModBase)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new CrossModBase();
    }

    public static ItemStack getEnergyCard(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound data = CrossModLoader.getEnergyData(te);
        if (data != null) {
            ItemStack card = new ItemStack(ModItems.itemCard, 1, 0);
            ItemStackHelper.setCoordinates(card, pos);
            return card;
        }
        return ItemStack.field_190927_a;
    }

    public static NBTTagCompound getEnergyData(TileEntity te) {
        NBTTagCompound tag = ic2.getEnergyData(te);
        if (tag == null) {
            tag = techReborn.getEnergyData(te);
        }
        if (tag == null) {
            tag = appEng.getEnergyData(te);
        }
        if (tag == null) {
            tag = draconic.getEnergyData(te);
        }
        if (tag == null) {
            tag = galacticraft.getEnergyData(te);
        }
        if (tag == null) {
            tag = mekanism.getEnergyData(te);
        }
        if (tag == null) {
            tag = nuclearCraft.getEnergyData(te);
        }
        if (tag == null) {
            tag = thermalExpansion.getEnergyData(te);
        }
        return tag;
    }

    public static ItemStack getGeneratorCard(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack card = ic2.getGeneratorCard(te);
        if (!card.func_190926_b()) {
            return card;
        }
        card = techReborn.getGeneratorCard(te);
        if (!card.func_190926_b()) {
            return card;
        }
        card = thermalExpansion.getGeneratorCard(te);
        if (!card.func_190926_b()) {
            return card;
        }
        return buildCraft.getGeneratorCard(te);
    }

    public static List<IFluidTank> getAllTanks(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        if (te instanceof IFluidHandler) {
            IFluidTankProperties[] tanks = ((IFluidHandler)te).getTankProperties();
            ArrayList<IFluidTank> result = new ArrayList<IFluidTank>();
            for (IFluidTankProperties tank : tanks) {
                result.add((IFluidTank)new FluidTank(tank.getContents(), tank.getCapacity()));
            }
            return result;
        }
        List<IFluidTank> list = ic2.getAllTanks(te);
        if (list != null) {
            return list;
        }
        list = techReborn.getAllTanks(te);
        if (list != null) {
            return list;
        }
        list = galacticraft.getAllTanks(te);
        if (list != null) {
            return list;
        }
        list = bigReactors.getAllTanks(te);
        if (list != null) {
            return list;
        }
        list = nuclearCraft.getAllTanks(te);
        if (list != null) {
            return list;
        }
        list = mekanism.getAllTanks(te);
        if (list != null) {
            return list;
        }
        list = thermalExpansion.getAllTanks(te);
        if (list != null) {
            return list;
        }
        return buildCraft.getAllTanks(te);
    }

    public static IFluidTank getTankAt(World world, BlockPos pos) {
        List<IFluidTank> tanks = CrossModLoader.getAllTanks(world, pos);
        if (tanks == null || tanks.size() == 0) {
            return null;
        }
        return tanks.iterator().next();
    }
}

