/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.OreHelper;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import java.util.ArrayList;
import java.util.List;
import nc.config.NCConfig;
import nc.init.NCBlocks;
import nc.tile.energy.battery.TileBattery;
import nc.tile.energyFluid.TileEnergyFluid;
import nc.tile.generator.TileFissionController;
import nc.tile.internal.fluid.Tank;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;

public class CrossNuclearCraft
extends CrossModBase {
    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        if (te instanceof TileBattery) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 13);
            tag.func_74780_a("storage", (double)((TileBattery)te).getEnergyStored());
            tag.func_74780_a("maxStorage", (double)((TileBattery)te).getMaxEnergyStored());
            return tag;
        }
        return null;
    }

    @Override
    public int getReactorHeat(World world, BlockPos pos) {
        for (int xoffset = -1; xoffset < 2; ++xoffset) {
            for (int yoffset = -1; yoffset < 2; ++yoffset) {
                for (int zoffset = -1; zoffset < 2; ++zoffset) {
                    TileEntity te = world.func_175625_s(pos.func_177965_g(xoffset).func_177981_b(yoffset).func_177970_e(zoffset));
                    if (!(te instanceof TileFissionController)) continue;
                    return (int)Math.round(((TileFissionController)te).heat);
                }
            }
        }
        return -1;
    }

    @Override
    public List<IFluidTank> getAllTanks(TileEntity te) {
        if (te instanceof TileEnergyFluid) {
            List tanks = ((TileEnergyFluid)te).getTanks();
            ArrayList<IFluidTank> result = new ArrayList<IFluidTank>();
            for (Tank tank : tanks) {
                result.add((IFluidTank)tank);
            }
            return result;
        }
        return null;
    }

    @Override
    public void loadOreInfo() {
        for (int i = 0; i < 8; ++i) {
            if (!NCConfig.ore_gen[i]) continue;
            EnergyControl.oreHelper.put(OreHelper.getId(NCBlocks.ore, i), new OreHelper(NCConfig.ore_min_height[i], NCConfig.ore_max_height[i], NCConfig.ore_size[i] + 2, NCConfig.ore_rate[i]));
        }
    }
}

