/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui;

import com.google.common.collect.Lists;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.containers.ContainerKitAssembler;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.tileentities.TileEntityKitAssembler;
import com.zuxelus.zlib.gui.GuiContainerBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiKitAssembler
extends GuiContainerBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("energycontrol", "textures/gui/gui_kit_assembler.png");
    private ContainerKitAssembler container;
    private GuiTextField textboxTitle;
    private boolean modified;

    public GuiKitAssembler(ContainerKitAssembler container) {
        super(container, "tile.kit_assembler.name", TEXTURE);
        this.container = container;
        this.field_147000_g = 206;
    }

    protected void initControls() {
        ItemStack stack = ((TileEntityKitAssembler)this.container.te).func_70301_a(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemCardMain) {
            if (!this.modified) {
                this.textboxTitle = new GuiTextField(0, this.field_146289_q, 7, 16, 162, 18);
                this.textboxTitle.func_146195_b(true);
                this.textboxTitle.func_146180_a(new ItemCardReader(stack).getTitle());
            }
        } else {
            this.modified = false;
            this.textboxTitle = null;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.initControls();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        Slot slot = this.container.func_75139_a(0);
        if (this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY) && slot.func_111238_b()) {
            this.renderInfoToolTip(slot, mouseX, mouseY);
        } else {
            this.func_191948_b(mouseX, mouseY);
        }
    }

    private void renderInfoToolTip(Slot slot, int x, int y) {
        List<PanelString> data;
        ItemStack stack = slot.func_75211_c();
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemCardMain)) {
            return;
        }
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        List stackList = stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        ArrayList list = Lists.newArrayList();
        if (stackList.size() > 0) {
            list.add((String)stackList.get(0));
        }
        if ((data = new ItemCardReader(stack).getAllData()) != null) {
            for (PanelString panelString : data) {
                if (panelString.textLeft == null) continue;
                list.add(TextFormatting.GRAY + panelString.textLeft);
            }
        }
        this.drawHoveringText(list, x, y, font == null ? this.field_146289_q : font);
        GuiUtils.postItemToolTip();
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int energyHeight = ((TileEntityKitAssembler)this.container.te).getEnergyFactor();
        if (energyHeight > 0) {
            this.func_73729_b(this.field_147003_i + 9, this.field_147009_r + 62 + (14 - energyHeight), 176, 14 - energyHeight, 14, energyHeight);
        }
        int productionWidth = ((TileEntityKitAssembler)this.container.te).getProductionFactor();
        if (energyHeight > 0) {
            this.func_73729_b(this.field_147003_i + 86, this.field_147009_r + 60, 176, 15, productionWidth, 17);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawCenteredText(this.name, this.field_146999_f, 6);
        if (this.textboxTitle != null) {
            this.textboxTitle.func_146194_f();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.textboxTitle != null) {
            boolean focused = this.textboxTitle.func_146206_l();
            this.textboxTitle.func_146192_a(mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton);
            if (this.textboxTitle.func_146206_l() != focused) {
                this.updateTitle();
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.textboxTitle != null) {
            this.textboxTitle.func_146178_a();
        }
        this.initControls();
    }

    protected void updateTitle() {
        if (this.textboxTitle == null) {
            return;
        }
        if (((TileEntityKitAssembler)this.container.te).func_145831_w().field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 4);
            tag.func_74768_a("slot", 0);
            tag.func_74778_a("title", this.textboxTitle.func_146179_b());
            NetworkHelper.updateSeverTileEntity(((TileEntityKitAssembler)this.container.te).func_174877_v(), tag);
            ItemStack card = ((TileEntityKitAssembler)this.container.te).func_70301_a(0);
            if (!card.func_190926_b() && card.func_77973_b() instanceof ItemCardMain) {
                new ItemCardReader(card).setTitle(this.textboxTitle.func_146179_b());
            }
        }
    }

    public void func_146281_b() {
        this.updateTitle();
        super.func_146281_b();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.textboxTitle != null && this.textboxTitle.func_146206_l()) {
            if (keyCode == 1) {
                this.field_146297_k.field_71439_g.func_71053_j();
            } else if (typedChar == '\r') {
                this.updateTitle();
            } else {
                this.modified = true;
                this.textboxTitle.func_146201_a(typedChar, keyCode);
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }
}

