/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui;

import com.zuxelus.energycontrol.containers.ContainerSeedLibrary;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.tileentities.TileEntitySeedLibrary;
import com.zuxelus.energycontrol.utils.SeedLibraryFilter;
import com.zuxelus.zlib.gui.controls.GuiButtonGeneral;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiSeedLibrary
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("energycontrol:textures/gui/gui_seed_library.png");
    public static final String BLACK = "\u00a70";
    public static final String DARK_BLUE = "\u00a71";
    public static final String DARK_GREEN = "\u00a72";
    public static final String DARK_AQUA = "\u00a73";
    public static final String DARK_RED = "\u00a74";
    public static final String DARK_PURPLE = "\u00a75";
    public static final String GOLD = "\u00a76";
    public static final String GRAY = "\u00a77";
    public static final String DARK_GRAY = "\u00a78";
    public static final String BLUE = "\u00a79";
    public static final String GREEN = "\u00a7A";
    public static final String AQUA = "\u00a7B";
    public static final String RED = "\u00a7C";
    public static final String LIGHT_PURPLE = "\u00a7D";
    public static final String YELLOW = "\u00a7E";
    public static final String WHITE = "\u00a7F";
    private ContainerSeedLibrary container;
    public int lastMouseX = -1;
    public int lastMouseY = -1;
    String tooltip = null;
    private boolean rightClick = false;
    private GuiButton rightSelect;
    public static final int BORDER = 4;
    public int main_width;
    public int main_height;
    public int left;
    public int top;
    public int center;
    public int middle;
    public int right;
    public int bottom;
    public int sliders_x;
    public int sliders_y;
    public int sliders_spacing;
    public int current_slider = -1;
    public int drag_start_x = 0;
    public int drag_start_value = 0;
    public GuiButtonGeneral unk_type_button;
    public GuiButtonGeneral unk_ggr_button;

    public GuiSeedLibrary(ContainerSeedLibrary container) {
        super((Container)container);
        this.container = container;
        this.field_147000_g = 222;
        this.main_width = this.field_146999_f - 8;
        this.main_height = this.field_147000_g - 96 - 8 - 36;
        this.left = 4;
        this.top = 4;
        this.center = this.left + this.main_width / 2;
        this.middle = this.top + this.main_height / 2;
        this.right = this.left + this.main_width;
        this.bottom = this.top + this.main_height;
        this.sliders_x = this.center + this.main_width / 4 - 31;
        this.sliders_y = this.top + 2 + 9 - 1;
        this.sliders_spacing = 20;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        GuiButtonGeneral importButton = new GuiButtonGeneral(0, this.field_147003_i + 132, this.field_147009_r + 88, 18, 20, TEXTURE, 176, 0, 21);
        importButton.tooltip = "Import seeds";
        this.func_189646_b(importButton);
        GuiButtonGeneral exportButton = new GuiButtonGeneral(1, this.field_147003_i + 151, this.field_147009_r + 88, 18, 20, TEXTURE, 176, 42, 21);
        exportButton.tooltip = "Export seeds";
        this.func_189646_b(exportButton);
        this.unk_type_button = new GuiButtonGeneral(2, this.field_147003_i + this.left + this.main_width / 8 - 9, this.field_147009_r + this.middle + 20, 18, 20, TEXTURE, 176, 84, 21);
        this.func_189646_b(this.unk_type_button);
        this.unk_ggr_button = new GuiButtonGeneral(3, this.field_147003_i + this.left + this.main_width * 3 / 8 - 9, this.field_147009_r + this.middle + 20, 18, 20, TEXTURE, 176, 84, 21);
        this.func_189646_b(this.unk_ggr_button);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146284_a(GuiButton button) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("type", 1);
        tag.func_74768_a("button", button.field_146127_k);
        tag.func_74757_a("click", this.rightClick);
        NetworkHelper.updateSeverTileEntity(((TileEntitySeedLibrary)this.container.te).func_174877_v(), tag);
    }

    public void drawCenteredString(String s, int x, int y, int color) {
        this.field_146289_q.func_78276_b(s, x - this.field_146289_q.func_78256_a(s) / 2, y, color);
    }

    public void drawRightString(String s, int x, int y, int color) {
        this.field_146289_q.func_78276_b(s, x - this.field_146289_q.func_78256_a(s), y, color);
    }

    public void draw3DRect(int left, int top, int right, int bottom) {
        GuiSeedLibrary.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)-13158601);
        GuiSeedLibrary.func_73734_a((int)(left + 1), (int)(top + 1), (int)right, (int)bottom, (int)-1);
        GuiSeedLibrary.func_73734_a((int)(left + 1), (int)(top + 1), (int)(right - 1), (int)(bottom - 1), (int)-3750202);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        SeedLibraryFilter filter = ((TileEntitySeedLibrary)this.container.te).getGUIFilter();
        this.drawCenteredString("Seed Type", this.left + this.main_width / 4, this.top + 2, 0x404040);
        this.drawCenteredString(I18n.func_135052_a((String)filter.getCropName(), (Object[])new Object[0]), this.left + this.main_width / 4, this.top + 2 + 8 + 1 + 18 + 2, 0x404040);
        String count = ((TileEntitySeedLibrary)this.container.te).seeds_available >= 65535 ? "MANY" : ((TileEntitySeedLibrary)this.container.te).seeds_available + "";
        this.drawCenteredString(count, 108, 90, 0x404040);
        this.drawCenteredString("Seeds", 108, 99, 0x404040);
        this.drawCenteredString("Missing info", this.left + this.main_width / 4, this.middle + 2, 0x404040);
        this.drawCenteredString("Type", this.left + this.main_width / 8, this.middle + 11, 0x404040);
        this.drawCenteredString("GGR", this.left + this.main_width * 3 / 8, this.middle + 11, 0x404040);
        if (filter.unknown_type == 0) {
            this.unk_type_button.setTextureTop(168);
            this.unk_type_button.tooltip = "Seeds with unknown type \u00a7Cexcluded";
        } else if (filter.unknown_type == 1) {
            this.unk_type_button.setTextureTop(84);
            this.unk_type_button.tooltip = "Seeds with unknown type included";
        } else {
            this.unk_type_button.setTextureTop(126);
            this.unk_type_button.tooltip = "Seeds with unknown type \u00a7Aonly";
        }
        if (filter.unknown_ggr == 0) {
            this.unk_ggr_button.setTextureTop(168);
            this.unk_ggr_button.tooltip = "Seeds with unknown GGR \u00a7Cexcluded";
        } else if (filter.unknown_ggr == 1) {
            this.unk_ggr_button.setTextureTop(84);
            this.unk_ggr_button.tooltip = "Seeds with unknown GGR included";
        } else {
            this.unk_ggr_button.setTextureTop(126);
            this.unk_ggr_button.tooltip = "Seeds with unknown GGR \u00a7Aonly";
        }
        if (!((TileEntitySeedLibrary)this.container.te).getActive()) {
            GuiSeedLibrary.func_73734_a((int)this.left, (int)this.top, (int)this.right, (int)(this.bottom + 22), (int)-16777216);
            this.drawCenteredString("Out of power.", this.center, this.middle - 3, 0x404040);
            this.drawCenteredString("Connect to LV power", this.center, this.middle + 6, 0x404040);
            this.drawCenteredString("or insert a battery.", this.center, this.middle + 15, 0x404040);
            this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
            this.func_73729_b(this.left + 5, this.bottom + 2, 178, 44, 14, 16);
            this.field_146289_q.func_78276_b("Battery slot", this.left + 23, this.bottom + 5, 0x404040);
        }
        this.field_146289_q.func_78276_b("Inventory", 8, this.field_147000_g - 96 + 4, 0x404040);
        if (this.lastMouseX != mouseX || this.lastMouseY != mouseY) {
            this.onMouseMoved(mouseX, mouseY);
        }
        if (this.tooltip != null && this.tooltip.length() > 0) {
            this.func_146279_a(this.tooltip, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.func_73729_b(0, 0, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(this.left + this.main_width / 4 - 9, this.top + 11, 194, 0, 18, 18);
        SeedLibraryFilter filter = ((TileEntitySeedLibrary)this.container.te).getGUIFilter();
        this.drawSlider(0, filter.min_growth, filter.max_growth);
        this.drawSlider(1, filter.min_gain, filter.max_gain);
        this.drawSlider(2, filter.min_resistance, filter.max_resistance);
        this.drawSlider(3, filter.min_total / 3, filter.max_total / 3);
        GL11.glPopMatrix();
    }

    private void drawSlider(int index, int min, int max) {
        int pre_size = min * 2;
        int in_size = (max - min) * 2 + 1;
        int post_size = (31 - max) * 2;
        int x = this.sliders_x;
        int y = this.sliders_y + 1 + this.sliders_spacing * index;
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_73729_b(x, y, 0, 224, pre_size, 7);
        GL11.glColor4f((float)0.0f, (float)0.5f, (float)0.0f, (float)1.0f);
        this.func_73729_b(x + pre_size, y, pre_size, 224, in_size, 7);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_73729_b(x + pre_size + in_size, y, pre_size + in_size, 224, post_size, 7);
        GL11.glColor4f((float)0.0f, (float)0.5f, (float)0.0f, (float)1.0f);
        this.func_73729_b(x + pre_size - 2, y - 1, 0, 232, 3, 9);
        this.func_73729_b(x + pre_size + in_size - 1, y - 1, 3, 232, 3, 9);
        GL11.glColor4f((float)0.0f, (float)0.5f, (float)0.0f, (float)0.25f);
        this.func_73729_b(x + pre_size - 2, y - 1, 6, 232, 3, 9);
        this.func_73729_b(x + pre_size + in_size - 1, y - 1, 9, 232, 3, 9);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (!((TileEntitySeedLibrary)this.container.te).getActive()) {
            this.current_slider = -1;
            return;
        }
        if (mouseButton == 1) {
            this.rightClick = true;
            for (int l = 0; l < this.field_146292_n.size(); ++l) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
                if (guibutton.field_146127_k < 4 || guibutton.field_146127_k > 9 || !guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                this.rightSelect = guibutton;
                this.func_146284_a(guibutton);
            }
            this.rightClick = false;
        }
        if (mouseButton == 0) {
            this.current_slider = this.getSliderAt(mouseX, mouseY);
            if (this.current_slider != -1) {
                this.drag_start_x = mouseX;
                this.drag_start_value = ((TileEntitySeedLibrary)this.container.te).getSliderValue(this.current_slider);
            }
        }
    }

    public int getSliderAt(int x, int y) {
        if ((x -= this.field_147003_i) < this.sliders_x - 2 || (y -= this.field_147009_r) < this.sliders_y) {
            return -1;
        }
        x -= this.sliders_x;
        int bar = (y -= this.sliders_y) / this.sliders_spacing;
        int remainder = y % this.sliders_spacing;
        if (bar > 3 || remainder >= 10) {
            return -1;
        }
        int min = ((TileEntitySeedLibrary)this.container.te).getSliderValue(bar * 2);
        int max = ((TileEntitySeedLibrary)this.container.te).getSliderValue(bar * 2 + 1);
        if (x < min * 2 - 2) {
            return -1;
        }
        if (x <= min * 2) {
            return bar * 2;
        }
        if (x < max * 2) {
            return -1;
        }
        if (x <= max * 2 + 2) {
            return bar * 2 + 1;
        }
        return -1;
    }

    public String getSliderName(int slider) {
        int bar = slider / 2;
        int arrow = slider % 2;
        String name = arrow == 0 ? "Minimum " : "Maximum ";
        name = bar == 0 ? name + "\u00a72Growth" : (bar == 1 ? name + "\u00a76Gain" : (bar == 2 ? name + "\u00a7BResistance" : name + "\u00a7ETotal"));
        return name;
    }

    private void setSliderValue(int slider, int value) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("type", 2);
        tag.func_74768_a("slider", slider);
        tag.func_74768_a("value", value);
        NetworkHelper.updateSeverTileEntity(((TileEntitySeedLibrary)this.container.te).func_174877_v(), tag);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.rightSelect != null && state == 1) {
            this.rightSelect.func_146118_a(mouseX, mouseY);
            this.rightSelect = null;
        }
        if (!((TileEntitySeedLibrary)this.container.te).getActive()) {
            this.current_slider = -1;
            return;
        }
        if (state == 0 && this.current_slider != -1) {
            this.current_slider = -1;
        }
    }

    private void onMouseMoved(int newX, int newY) {
        boolean is_max;
        this.tooltip = this.getTooltip(newX, newY);
        if (this.current_slider == -1) {
            return;
        }
        int value = this.drag_start_value + (newX - this.drag_start_x) / 2;
        if (value < 0) {
            value = 0;
        }
        if (value > 31) {
            value = 31;
        }
        int bar = this.current_slider / 2;
        int min = ((TileEntitySeedLibrary)this.container.te).getSliderValue(bar * 2);
        int max = ((TileEntitySeedLibrary)this.container.te).getSliderValue(bar * 2 + 1);
        boolean bl = is_max = this.current_slider % 2 == 1;
        if (is_max && min > value) {
            value = min;
        } else if (!is_max && max < value) {
            value = max;
        }
        if (((TileEntitySeedLibrary)this.container.te).getSliderValue(this.current_slider) != value) {
            this.setSliderValue(this.current_slider, value);
        }
    }

    private String getTooltip(int x, int y) {
        int slider = this.current_slider;
        if (slider == -1) {
            slider = this.getSliderAt(x, y);
        }
        if (slider != -1) {
            int value = ((TileEntitySeedLibrary)this.container.te).getSliderValue(slider);
            if (slider > 5) {
                value *= 3;
            }
            return this.getSliderName(slider) + WHITE + ": " + value;
        }
        for (Object control : this.field_146292_n) {
            String tooltip;
            if (!(control instanceof GuiButtonGeneral) || (tooltip = ((GuiButtonGeneral)((Object)control)).getActiveTooltip(x, y)) == null) continue;
            return tooltip;
        }
        return null;
    }
}

