/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items;

import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.ItemThermometer;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.reactor.IReactor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDigitalThermometer
extends ItemThermometer
implements IElectricItem {
    protected static final int CAPACITY = 12000;
    protected static final int TRANSFER_LIMIT = 250;

    public ItemDigitalThermometer() {
        this.func_77656_e(13);
        this.func_77627_a(true);
    }

    @Override
    protected boolean canTakeDamage(ItemStack itemstack, int i) {
        return ElectricItem.manager.discharge(itemstack, i *= 50, Integer.MAX_VALUE, true, false, true) == (double)i;
    }

    @Override
    protected void messagePlayer(EntityPlayer player, IReactor reactor) {
        int heat = reactor.getHeat();
        int maxHeat = reactor.getMaxHeat();
        player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.ec.ThermoDigital", new Object[]{heat, maxHeat * 50 / 100, maxHeat * 85 / 100}));
    }

    @Override
    protected void damage(ItemStack stack, int i, EntityPlayer player) {
        ElectricItem.manager.use(stack, 50 * i, (EntityLivingBase)player);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return 12000.0;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 1;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return 250.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)CrossModLoader.ic2.getChargedStack(new ItemStack((Item)this, 1)));
        items.add((Object)new ItemStack((Item)this, 1, this.func_77612_l()));
    }
}

