/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPartBase;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartBase;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardBigReactors
extends ItemCardBase {
    private static DecimalFormat df = new DecimalFormat("0.0");

    public ItemCardBigReactors() {
        super(24, "card_big_reactors");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity te = world.func_175625_s(target);
        if (te instanceof TileEntityReactorPartBase) {
            MultiblockReactor reactor = ((TileEntityReactorPartBase)te).getReactorController();
            if (reactor == null) {
                return CardState.NO_TARGET;
            }
            reader.setInt("type", 1);
            reader.setBoolean("reactorPoweredB", reactor.getActive());
            reader.setBoolean("cooling", reactor.isPassivelyCooled());
            reader.setString("system", reactor.getPowerSystem().unitOfMeasure);
            reader.setDouble("heat", Double.valueOf(reactor.getFuelHeat()));
            reader.setInt("coreHeat", (int)reactor.getReactorHeat());
            reader.setDouble("storage", Double.valueOf(reactor.getEnergyStored()));
            reader.setDouble("capacity", Double.valueOf(reactor.getEnergyCapacity()));
            reader.setDouble("output", Double.valueOf(reactor.getEnergyGeneratedLastTick()));
            reader.setInt("rods", reactor.getFuelRodCount());
            reader.setInt("fuel", reactor.getFuelAmount());
            reader.setInt("waste", reactor.getWasteAmount());
            reader.setInt("fuelCapacity", reactor.getCapacity());
            reader.setDouble("consumption", Double.valueOf(reactor.getFuelConsumedLastTick()));
            BlockPos min = reactor.getMinimumCoord();
            BlockPos max = reactor.getMaximumCoord();
            reader.setString("size", String.format("%sx%sx%s", max.func_177958_n() - min.func_177958_n() + 1, max.func_177956_o() - min.func_177956_o() + 1, max.func_177952_p() - min.func_177952_p() + 1));
            return CardState.OK;
        }
        if (te instanceof TileEntityTurbinePartBase) {
            MultiblockTurbine turbine = ((TileEntityTurbinePartBase)te).getTurbine();
            if (turbine == null) {
                return CardState.NO_TARGET;
            }
            reader.setInt("type", 2);
            reader.setBoolean("reactorPoweredB", turbine.getActive());
            reader.setString("system", turbine.getPowerSystem().unitOfMeasure);
            reader.setDouble("storage", Double.valueOf(turbine.getEnergyStored()));
            reader.setDouble("capacity", Double.valueOf(turbine.getEnergyCapacity()));
            reader.setDouble("output", Double.valueOf(turbine.getEnergyGeneratedLastTick()));
            reader.setDouble("speed", Double.valueOf(turbine.getRotorSpeed()));
            reader.setDouble("speedMax", Double.valueOf(turbine.getMaxRotorSpeed()));
            reader.setDouble("efficiency", Double.valueOf(turbine.getRotorEfficiencyLastTick()));
            reader.setDouble("consumption", Double.valueOf(turbine.getFluidConsumedLastTick()));
            reader.setInt("blades", turbine.getNumRotorBlades());
            reader.setInt("mass", turbine.getRotorMass());
            BlockPos min = turbine.getMinimumCoord();
            BlockPos max = turbine.getMaximumCoord();
            reader.setString("size", String.format("%sx%sx%s", max.func_177958_n() - min.func_177958_n() + 1, max.func_177956_o() - min.func_177956_o() + 1, max.func_177952_p() - min.func_177952_p() + 1));
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        String euType = reader.getString("system");
        switch (reader.getInt("type")) {
            case 1: {
                if ((displaySettings & 2) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelCoreHeat", reader.getInt("heat").intValue(), showLabels));
                    result.add(new PanelString("msg.ec.InfoPanelCasingHeat", reader.getDouble("coreHeat"), showLabels));
                    result.add(new PanelString("msg.ec.InfoPanelPassiveCooling", reader.getBoolean("cooling").toString(), showLabels));
                }
                if ((displaySettings & 4) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelEnergy" + euType, reader.getDouble("storage"), showLabels));
                }
                if ((displaySettings & 8) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelCapacity" + euType, reader.getDouble("capacity"), showLabels));
                }
                if ((displaySettings & 0x10) > 0) {
                    if (reader.getBoolean("cooling").booleanValue()) {
                        result.add(new PanelString("msg.ec.InfoPanelOutput" + euType, reader.getDouble("output"), showLabels));
                    } else {
                        result.add(new PanelString("msg.ec.InfoPanelOutputmB", reader.getDouble("output"), showLabels));
                    }
                }
                if ((displaySettings & 0x20) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelFuelmb", reader.getInt("fuel").intValue(), showLabels));
                    result.add(new PanelString("msg.ec.InfoPanelWastemb", reader.getInt("waste").intValue(), showLabels));
                    result.add(new PanelString("msg.ec.InfoPanelCapacitymB", reader.getInt("fuelCapacity").intValue(), showLabels));
                    result.add(new PanelString("msg.ec.InfoPanelBurnupRatemb", reader.getDouble("consumption"), showLabels));
                }
                if ((displaySettings & 0x40) <= 0) break;
                result.add(new PanelString("msg.ec.InfoPanelFuelRods", reader.getDouble("rods"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelSize", reader.getString("size"), showLabels));
                break;
            }
            case 2: {
                if ((displaySettings & 2) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelRotorSpeed", df.format(reader.getDouble("speed")), showLabels));
                    result.add(new PanelString("msg.ec.InfoPanelMaxSpeed", reader.getDouble("speedMax"), showLabels));
                    result.add(new PanelString("msg.ec.InfoPanelRotorEfficiency", reader.getDouble("efficiency"), showLabels));
                }
                if ((displaySettings & 4) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelEnergy" + euType, reader.getDouble("storage"), showLabels));
                }
                if ((displaySettings & 8) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelCapacity" + euType, reader.getDouble("capacity"), showLabels));
                }
                if ((displaySettings & 0x10) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelOutput" + euType, reader.getDouble("output"), showLabels));
                }
                if ((displaySettings & 0x20) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelBurnupRatemb", reader.getDouble("consumption"), showLabels));
                }
                if ((displaySettings & 0x40) <= 0) break;
                result.add(new PanelString("msg.ec.InfoPanelBlades", reader.getInt("blades").intValue(), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelRotorMass", reader.getInt("mass").intValue(), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelSize", reader.getString("size"), showLabels));
            }
        }
        if ((displaySettings & 1) > 0) {
            this.addOnOff(result, isServer, reader.getBoolean("reactorPoweredB"));
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(6);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOnOff", (Object[])new Object[0]), 1, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelHeat", (Object[])new Object[0]), 2, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEnergy", (Object[])new Object[0]), 4, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelCapacity", (Object[])new Object[0]), 8, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOutputRF", (Object[])new Object[0]), 16, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbFuel", (Object[])new Object[0]), 32, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelAdditionalInfo", (Object[])new Object[0]), 64, this.damage));
        return result;
    }

    @Override
    public int getKitFromCard() {
        return 11;
    }
}

