/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import com.zuxelus.energycontrol.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardEnergyArray
extends ItemCardBase {
    private static final int STATUS_NOT_FOUND = Integer.MIN_VALUE;
    private static final int STATUS_OUT_OF_RANGE = -2147483647;

    public ItemCardEnergyArray() {
        super(10, "card_energy_array");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        int cardCount = reader.getCardCount();
        if (cardCount == 0) {
            return CardState.INVALID_CARD;
        }
        double totalEnergy = 0.0;
        boolean foundAny = false;
        boolean outOfRange = false;
        for (int i = 0; i < cardCount; ++i) {
            BlockPos target = this.getCoordinates(reader, i);
            int dx = target.func_177958_n() - pos.func_177958_n();
            int dy = target.func_177956_o() - pos.func_177956_o();
            int dz = target.func_177952_p() - pos.func_177952_p();
            if (Math.abs(dx) <= range && Math.abs(dy) <= range && Math.abs(dz) <= range) {
                TileEntity te = world.func_175625_s(target);
                if (te != null) {
                    NBTTagCompound tag = CrossModLoader.getEnergyData(te);
                    if (tag != null) {
                        double stored = tag.func_74769_h("storage");
                        double capacity = tag.func_74769_h("maxStorage");
                        totalEnergy += stored;
                        reader.setInt(String.format("_%denergy", i), (int)stored);
                        reader.setInt(String.format("_%dmaxStorage", i), (int)capacity);
                        foundAny = true;
                        continue;
                    }
                    reader.setInt(String.format("_%denergy", i), Integer.MIN_VALUE);
                    continue;
                }
                reader.setInt(String.format("_%denergy", i), Integer.MIN_VALUE);
                continue;
            }
            reader.setInt(String.format("_%denergy", i), -2147483647);
            outOfRange = true;
        }
        reader.setDouble("energy", totalEnergy);
        if (!foundAny) {
            if (outOfRange) {
                return CardState.OUT_OF_RANGE;
            }
            return CardState.NO_TARGET;
        }
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        double totalEnergy = 0.0;
        double totalStorage = 0.0;
        boolean showEach = (displaySettings & 1) > 0;
        boolean showSummary = (displaySettings & 2) > 0;
        boolean showEnergy = (displaySettings & 4) > 0;
        boolean showFree = (displaySettings & 8) > 0;
        boolean showStorage = (displaySettings & 0x10) > 0;
        boolean showPercentage = (displaySettings & 0x20) > 0;
        for (int i = 0; i < reader.getCardCount(); ++i) {
            boolean isNotFound;
            int energy = reader.getInt(String.format("_%denergy", i));
            int storage = reader.getInt(String.format("_%dmaxStorage", i));
            boolean isOutOfRange = energy == -2147483647;
            boolean bl = isNotFound = energy == Integer.MIN_VALUE;
            if (showSummary && !isOutOfRange && !isNotFound) {
                totalEnergy += (double)energy;
                totalStorage += (double)storage;
            }
            if (!showEach) continue;
            if (isOutOfRange) {
                result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelOutOfRangeN", i + 1)));
                continue;
            }
            if (isNotFound) {
                result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelNotFoundN", i + 1)));
                continue;
            }
            if (showEnergy) {
                if (showLabels) {
                    result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelEnergyN", i + 1, StringUtils.getFormatted("", energy, false))));
                } else {
                    result.add(new PanelString(StringUtils.getFormatted("", energy, false)));
                }
            }
            if (showFree) {
                if (showLabels) {
                    result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelFreeN", i + 1, StringUtils.getFormatted("", storage - energy, false))));
                } else {
                    result.add(new PanelString(StringUtils.getFormatted("", storage - energy, false)));
                }
            }
            if (showStorage) {
                if (showLabels) {
                    result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelStorageN", i + 1, StringUtils.getFormatted("", storage, false))));
                } else {
                    result.add(new PanelString(StringUtils.getFormatted("", storage, false)));
                }
            }
            if (!showPercentage) continue;
            if (showLabels) {
                result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelPercentageN", i + 1, StringUtils.getFormatted("", storage == 0 ? 100.0 : (double)((int)((double)energy / (double)storage * 100.0)), false))));
                continue;
            }
            result.add(new PanelString(StringUtils.getFormatted("", storage == 0 ? 100.0 : (double)((int)((double)energy / (double)storage * 100.0)), false)));
        }
        if (showSummary) {
            if (showEnergy) {
                result.add(new PanelString("msg.ec.InfoPanelEnergy", totalEnergy, showLabels));
            }
            if (showFree) {
                result.add(new PanelString("msg.ec.InfoPanelFree", totalStorage - totalEnergy, showLabels));
            }
            if (showStorage) {
                result.add(new PanelString("msg.ec.InfoPanelCapacity", totalStorage, showLabels));
            }
            if (showPercentage) {
                result.add(new PanelString("msg.ec.InfoPanelPercentage", totalStorage == 0.0 ? 100.0 : totalEnergy / totalStorage * 100.0, showLabels));
            }
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(6);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEachCard", (Object[])new Object[0]), 1, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEnergy", (Object[])new Object[0]), 4, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelFree", (Object[])new Object[0]), 8, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelStorage", (Object[])new Object[0]), 16, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelPercentage", (Object[])new Object[0]), 32, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelTotal", (Object[])new Object[0]), 2, this.damage));
        return result;
    }

    @Override
    public boolean isRemoteCard() {
        return false;
    }

    @Override
    public int getKitFromCard() {
        return 0;
    }
}

