/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardGeneratorKinetic
extends ItemCardBase {
    public ItemCardGeneratorKinetic() {
        super(5, "card_generator_kinetic");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity entity = world.func_175625_s(target);
        NBTTagCompound tag = CrossModLoader.ic2.getGeneratorKineticData(entity);
        if (tag == null || !tag.func_74764_b("type")) {
            return CardState.NO_TARGET;
        }
        reader.setInt("type", tag.func_74762_e("type"));
        switch (tag.func_74762_e("type")) {
            case 1: {
                reader.setDouble("output", tag.func_74769_h("output"));
                reader.setBoolean("active", tag.func_74767_n("active"));
                reader.setDouble("storage", tag.func_74769_h("storage"));
                reader.setDouble("maxStorage", tag.func_74769_h("maxStorage"));
                reader.setDouble("energy", tag.func_74769_h("energy"));
                reader.setDouble("maxEnergy", tag.func_74769_h("maxEnergy"));
                reader.setInt("items", tag.func_74762_e("items"));
                reader.setDouble("multiplier", tag.func_74769_h("multiplier"));
                break;
            }
            case 2: {
                reader.setDouble("storage", tag.func_74769_h("storage"));
                reader.setDouble("maxStorage", tag.func_74769_h("maxStorage"));
                break;
            }
            case 3: {
                reader.setDouble("output", tag.func_74769_h("output"));
                reader.setBoolean("active", tag.func_74767_n("active"));
                reader.setDouble("storage", tag.func_74769_h("storage"));
                reader.setDouble("maxStorage", tag.func_74769_h("maxStorage"));
                break;
            }
            case 4: {
                reader.setBoolean("active", tag.func_74767_n("active"));
                reader.setDouble("storage", tag.func_74769_h("storage"));
                reader.setDouble("maxStorage", tag.func_74769_h("maxStorage"));
                reader.setDouble("energy", tag.func_74769_h("energy"));
                reader.setDouble("maxEnergy", tag.func_74769_h("maxEnergy"));
                reader.setDouble("multiplier", tag.func_74769_h("multiplier"));
                break;
            }
            case 5: 
            case 6: {
                reader.setDouble("output", tag.func_74769_h("output"));
                reader.setDouble("wind", tag.func_74769_h("wind"));
                reader.setDouble("multiplier", tag.func_74769_h("multiplier"));
                reader.setInt("height", tag.func_74762_e("height"));
                reader.setDouble("health", tag.func_74769_h("health"));
                break;
            }
            case 7: {
                reader.setString("status", tag.func_74779_i("status"));
                reader.setDouble("output", tag.func_74769_h("output"));
                reader.setDouble("multiplier", tag.func_74769_h("multiplier"));
                reader.setInt("condProgress", tag.func_74762_e("condProgress"));
            }
        }
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        switch (reader.getInt("type")) {
            case 1: {
                if ((settings & 1) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelOutputKU", reader.getDouble("output"), showLabels));
                }
                if ((settings & 2) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelEnergyKU", reader.getDouble("storage"), showLabels));
                }
                if ((settings & 4) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelCapacityKU", reader.getDouble("maxStorage"), showLabels));
                }
                if ((settings & 8) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelStorageEU", reader.getInt("energy").intValue(), showLabels));
                }
                if ((settings & 4) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelCapacityEU", reader.getDouble("maxEnergy"), showLabels));
                }
                if ((settings & 0x10) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelMotors", reader.getInt("items").intValue(), showLabels));
                }
                if ((settings & 0x20) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelMultiplier", reader.getDouble("multiplier"), showLabels));
                }
                this.addOnOff(result, isServer, reader.getBoolean("active"));
                break;
            }
            case 2: {
                if ((settings & 2) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelEnergyKU", reader.getDouble("storage"), showLabels));
                }
                if ((settings & 4) <= 0) break;
                result.add(new PanelString("msg.ec.InfoPanelCapacityKU", reader.getDouble("maxStorage"), showLabels));
                break;
            }
            case 3: {
                if ((settings & 1) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelOutputKU", reader.getDouble("output"), showLabels));
                }
                if ((settings & 8) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelStorageL", reader.getDouble("storage"), showLabels));
                }
                if ((settings & 4) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelCapacityL", reader.getDouble("maxStorage"), showLabels));
                }
                this.addOnOff(result, isServer, reader.getBoolean("active"));
                break;
            }
            case 4: {
                if ((settings & 2) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelEnergyKU", reader.getDouble("storage"), showLabels));
                }
                if ((settings & 4) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelCapacityKU", reader.getDouble("maxStorage"), showLabels));
                }
                if ((settings & 8) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelStorageHU", reader.getInt("energy").intValue(), showLabels));
                }
                if ((settings & 4) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelCapacityHU", reader.getDouble("maxEnergy"), showLabels));
                }
                if ((settings & 0x20) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelMultiplier", reader.getDouble("multiplier"), showLabels));
                }
                this.addOnOff(result, isServer, reader.getBoolean("active"));
                break;
            }
            case 5: {
                if ((settings & 1) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelOutputKU", reader.getDouble("output"), showLabels));
                }
                if ((settings & 2) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelWindStrength", reader.getDouble("wind"), showLabels));
                }
                if ((settings & 0x20) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelMultiplier", reader.getDouble("multiplier"), showLabels));
                }
                if ((settings & 0x40) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelHeight", reader.getInt("height").intValue(), showLabels));
                }
                if ((settings & 0x10) <= 0) break;
                result.add(new PanelString("msg.ec.InfoPanelRotorHealth", reader.getDouble("health"), showLabels));
                break;
            }
            case 6: {
                if ((settings & 1) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelOutputKU", reader.getDouble("output"), showLabels));
                }
                if ((settings & 2) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelWaterFlow", reader.getDouble("wind"), showLabels));
                }
                if ((settings & 0x20) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelMultiplier", reader.getDouble("multiplier"), showLabels));
                }
                if ((settings & 0x40) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelHeight", reader.getInt("height").intValue(), showLabels));
                }
                if ((settings & 0x10) <= 0) break;
                result.add(new PanelString("msg.ec.InfoPanelRotorHealth", reader.getDouble("health"), showLabels));
                break;
            }
            case 7: {
                if ((settings & 2) > 0) {
                    result.add(new PanelString(reader.getString("status"), "", true));
                }
                if ((settings & 1) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelOutputKU", reader.getDouble("output"), showLabels));
                }
                if ((settings & 0x20) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelMultiplier", reader.getDouble("multiplier"), showLabels));
                }
                if ((settings & 8) <= 0) break;
                result.add(new PanelString("msg.ec.InfoPanelWater", String.format("%s mB", Float.valueOf((float)reader.getInt("condProgress").intValue() / 100.0f)), showLabels));
            }
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(8);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOutput", (Object[])new Object[0]), 1, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEnergy", (Object[])new Object[0]), 2, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelCapacity", (Object[])new Object[0]), 4, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelStorage", (Object[])new Object[0]), 8, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelItems", (Object[])new Object[0]), 16, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelMultiplier", (Object[])new Object[0]), 32, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelHeight", (Object[])new Object[0]), 64, this.damage));
        return result;
    }

    @Override
    public int getKitFromCard() {
        return 4;
    }
}

