/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.tileentities.TileEntityEnergyStorage;
import ic2.api.energy.event.EnergyTileEvent;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.info.Info;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityAverageCounter
extends TileEntityEnergyStorage
implements ITickable {
    private static final int BASE_PACKET_SIZE = 32;
    protected static final int DATA_POINTS = 220;
    private boolean init;
    protected double[] data = new double[220];
    protected int index = 0;
    protected int updateTicker = this.tickRate = 20;
    protected int tickRate;
    protected short prevPeriod = 1;
    public short period = 1;
    protected int clientAverage = -1;
    private double lastReceivedPower = 0.0;

    public TileEntityAverageCounter() {
        super("tile.average_counter.name", 1, 32, 64);
    }

    public int getClientAverage() {
        if (this.clientAverage == -1) {
            return this.getAverage();
        }
        return this.clientAverage;
    }

    private int getAverage() {
        int start = 220 + this.index - this.period * 20;
        double sum = 0.0;
        for (int i = 0; i < this.period * 20; ++i) {
            sum += this.data[(start + i) % 220];
        }
        this.clientAverage = (int)Math.round(sum / (double)this.period / 20.0);
        return this.clientAverage;
    }

    private void setPeriod(short p) {
        this.period = p;
        if (!this.field_145850_b.field_72995_K && this.prevPeriod != this.period) {
            this.notifyBlockUpdate();
        }
        this.prevPeriod = this.period;
    }

    @Override
    public void onServerMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 1: {
                if (!tag.func_74764_b("value")) break;
                int event = tag.func_74762_e("value");
                if (event == 0) {
                    for (int i = 0; i < 220; ++i) {
                        this.data[i] = 0.0;
                    }
                    this.updateTicker = this.tickRate;
                    this.index = 0;
                    break;
                }
                this.setPeriod((short)event);
            }
        }
    }

    @Override
    public void onClientMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 1: {
                if (!tag.func_74764_b("value")) break;
                this.clientAverage = tag.func_74762_e("value");
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.writeProperties(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readProperties(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag = this.writeProperties(tag);
        return tag;
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        this.index = tag.func_74762_e("dataIndex");
        this.updateTicker = tag.func_74762_e("updateTicker");
        this.prevPeriod = this.period = tag.func_74765_d("period");
        for (int i = 0; i < 220; ++i) {
            this.data[i] = tag.func_74763_f("point-" + i);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readProperties(tag);
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74768_a("dataIndex", this.index);
        tag.func_74768_a("updateTicker", this.updateTicker);
        tag.func_74777_a("period", this.period);
        for (int i = 0; i < 220; ++i) {
            tag.func_74772_a("point-" + i, (long)this.data[i]);
        }
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        return this.writeProperties(super.func_189515_b(tag));
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.init) {
            this.init = true;
            this.refreshData();
        }
    }

    @Override
    public void drawEnergy(double amount) {
        super.drawEnergy(amount);
        int n = this.index;
        this.data[n] = this.data[n] + amount;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.index = (this.index + 1) % 220;
        this.data[this.index] = 0.0;
        this.getAverage();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.refreshData();
    }

    private void refreshData() {
        int upgradeCountTransormer = 0;
        ItemStack itemStack = this.func_70301_a(0);
        if (!itemStack.func_190926_b() && itemStack.func_77969_a(CrossModLoader.ic2.getItemStack("transformer"))) {
            upgradeCountTransormer = itemStack.func_190916_E();
        }
        upgradeCountTransormer = Math.min(upgradeCountTransormer, 4);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.output = 32 * (int)Math.pow(4.0, upgradeCountTransormer);
            this.capacity = this.output * 2;
            this.tier = upgradeCountTransormer + 1;
            if (Info.isIc2Available()) {
                EnergyTileEvent event;
                if (this.addedToEnet) {
                    event = new EnergyTileUnloadEvent(this);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                }
                this.addedToEnet = false;
                event = new EnergyTileLoadEvent(this);
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.addedToEnet = true;
            }
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isItemValid(index, stack);
    }

    @Override
    public boolean isItemValid(int slotIndex, ItemStack stack) {
        return stack.func_77969_a(CrossModLoader.ic2.getItemStack("transformer"));
    }

    private void notifyBlockUpdate() {
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 2);
    }

    @Override
    public double getOfferedEnergy() {
        return this.allowEmit ? (this.energy >= (double)this.output ? (double)this.output : this.energy) : 0.0;
    }
}

