/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.blocks.KitAssembler;
import com.zuxelus.energycontrol.init.ModItems;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.zlib.containers.slots.ISlotItemFilter;
import com.zuxelus.zlib.tileentities.ITilePacketHandler;
import com.zuxelus.zlib.tileentities.TileEntityInventory;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.info.Info;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityKitAssembler
extends TileEntityInventory
implements ITickable,
ITilePacketHandler,
ISlotItemFilter,
IEnergySink {
    public static final byte SLOT_INFO = 0;
    public static final byte SLOT_CARD1 = 1;
    public static final byte SLOT_ITEM = 2;
    public static final byte SLOT_CARD2 = 3;
    public static final byte SLOT_KIT = 4;
    private static final double CONSUMPTION = 1.0;
    private static final double PRODUCTION_TIME = 6000.0;
    private double maxStorage = 1000.0;
    private double energy = 0.0;
    private double production = 0.0;
    private boolean addedToEnet = false;
    private boolean active = false;

    public TileEntityKitAssembler() {
        super("tile.kit_assembler.name");
    }

    public double getEnergy() {
        return this.energy;
    }

    public int getEnergyFactor() {
        return (int)Math.round(this.energy / this.maxStorage * 14.0);
    }

    public double getProduction() {
        return this.production;
    }

    public int getProductionFactor() {
        return (int)Math.round(this.production / 6000.0 * 24.0);
    }

    @Override
    public void onServerMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 4: {
                ItemStack itemStack;
                if (!tag.func_74764_b("slot") || !tag.func_74764_b("title") || (itemStack = this.func_70301_a(tag.func_74762_e("slot"))).func_190926_b() || !(itemStack.func_77973_b() instanceof ItemCardMain)) break;
                new ItemCardReader(itemStack).setTitle(tag.func_74779_i("title"));
            }
        }
    }

    @Override
    public void onClientMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 1: {
                if (!tag.func_74764_b("energy") || !tag.func_74764_b("production")) break;
                this.energy = tag.func_74769_h("energy");
                this.production = tag.func_74769_h("production");
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.writeProperties(tag);
        tag.func_74757_a("active", this.active);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readProperties(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag = this.writeProperties(tag);
        this.updateActive();
        tag.func_74757_a("active", this.active);
        return tag;
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        if (tag.func_74764_b("energy")) {
            this.energy = tag.func_74769_h("energy");
        }
        if (tag.func_74764_b("production")) {
            this.production = tag.func_74769_h("production");
        }
        if (tag.func_74764_b("active")) {
            this.active = tag.func_74767_n("active");
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readProperties(tag);
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74780_a("energy", this.energy);
        tag.func_74780_a("production", this.production);
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        return this.writeProperties(super.func_189515_b(tag));
    }

    public void onLoad() {
        if (!this.addedToEnet && !this.field_145850_b.field_72995_K && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
            this.updateActive();
        }
    }

    public void func_145843_s() {
        this.onChunkUnload();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.addedToEnet && !this.field_145850_b.field_72995_K && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
    }

    public void func_73660_a() {
        if (!this.addedToEnet) {
            this.onLoad();
        }
        if (this.field_145850_b.field_72995_K || !this.active) {
            return;
        }
        if (this.energy >= 1.0) {
            this.energy -= 1.0;
            this.production += 1.0;
            if (this.production >= 6000.0) {
                ItemStack stack1 = this.func_70301_a(1);
                ItemStack stack2 = this.func_70301_a(3);
                ItemStack kit = this.func_70301_a(4);
                if (!stack1.func_190926_b() && stack1.func_77973_b() instanceof ItemCardMain && !stack2.func_190926_b() && stack2.func_77973_b() instanceof ItemCardMain && stack1.func_77952_i() == stack2.func_77952_i() && kit.func_190926_b()) {
                    int kit_damage = ItemCardMain.getKitFromCard(stack1.func_77952_i());
                    this.func_70304_b(1);
                    this.func_70304_b(3);
                    if (kit_damage != -1) {
                        this.func_70299_a(4, new ItemStack(ModItems.itemKit, 2, kit_damage));
                    }
                }
                this.production = 0.0;
                this.updateState();
            }
        } else {
            this.energy = 0.0;
            this.production = 0.0;
            this.updateState();
        }
    }

    public void notifyBlockUpdate() {
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 2);
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateState();
    }

    private void updateActive() {
        this.active = false;
        if (this.energy < 1.0) {
            return;
        }
        ItemStack stack1 = this.func_70301_a(1);
        if (stack1.func_190926_b() || !(stack1.func_77973_b() instanceof ItemCardMain)) {
            return;
        }
        ItemStack stack2 = this.func_70301_a(3);
        if (stack2.func_190926_b() || !(stack2.func_77973_b() instanceof ItemCardMain) || stack1.func_77952_i() != stack2.func_77952_i() || ItemCardMain.getKitFromCard(stack1.func_77952_i()) == -1) {
            return;
        }
        ItemStack kit = this.func_70301_a(4);
        if (!kit.func_190926_b()) {
            return;
        }
        this.active = true;
    }

    private void updateState() {
        boolean old = this.active;
        this.updateActive();
        if (this.active == old) {
            return;
        }
        this.production = 0.0;
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = iblockstate.func_177230_c();
        if (!(block instanceof KitAssembler) || (Boolean)iblockstate.func_177229_b((IProperty)KitAssembler.ACTIVE) == this.active) {
            return;
        }
        IBlockState newState = block.func_176223_P().func_177226_a((IProperty)KitAssembler.field_185512_D, iblockstate.func_177229_b((IProperty)KitAssembler.field_185512_D)).func_177226_a((IProperty)KitAssembler.ACTIVE, (Comparable)Boolean.valueOf(this.active));
        this.field_145850_b.func_180501_a(this.field_174879_c, newState, 3);
    }

    public int func_70302_i_() {
        return 5;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isItemValid(index, stack);
    }

    @Override
    public boolean isItemValid(int index, ItemStack stack) {
        switch (index) {
            case 1: 
            case 3: {
                return stack.func_77973_b() instanceof ItemCardMain && ItemCardMain.getKitFromCard(stack.func_77952_i()) != -1;
            }
            case 0: {
                return stack.func_77973_b() instanceof ItemCardMain;
            }
        }
        return false;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        return Math.max(0.0, this.maxStorage - this.energy);
    }

    @Override
    public int getSinkTier() {
        return 1;
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        this.energy += amount;
        double left = 0.0;
        if (this.energy > this.maxStorage) {
            left = this.energy - this.maxStorage;
            this.energy = this.maxStorage;
        }
        return left;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

