/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.zlib.items;

import com.zuxelus.zlib.containers.slots.ISlotItemFilter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public abstract class ItemInventory
implements IInventory,
ISlotItemFilter {
    private final ItemStack parent;
    protected NonNullList<ItemStack> inventory;
    private String customName;

    public ItemInventory(ItemStack parent, String name) {
        this.parent = parent;
        this.customName = name;
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.readFromParentNBT();
    }

    private void readFromParentNBT() {
        NBTTagCompound tag = this.parent.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            this.parent.func_77982_d(tag);
        }
        NBTTagList nbttaglist = tag.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound stackTag = nbttaglist.func_150305_b(i);
            this.func_70299_a(stackTag.func_74771_c("Slot"), new ItemStack(stackTag));
        }
    }

    private void writeToParentNBT() {
        NBTTagCompound tag = this.parent.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            this.parent.func_77982_d(tag);
        }
        NBTTagList list = new NBTTagList();
        for (byte i = 0; i < this.func_70302_i_(); i = (byte)((byte)(i + 1))) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", i);
            stack.func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("Items", (NBTBase)list);
    }

    public String func_70005_c_() {
        return this.customName;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.customName);
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 0 && slot < this.func_70302_i_() ? (ItemStack)this.inventory.get(slot) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        return itemstack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.inventory.set(slot, (Object)ItemStack.field_190927_a);
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.writeToParentNBT();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isItemValid(index, stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }
}

