/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy;

import com.google.common.base.CaseFormat;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;
import paulojjj.solarenergy.Tier;

public class Config {
    public static final String DEFAULT_CATEGORY = "general";
    public static final String SOLAR_GENERATOR_CATEGORY = "solarGenerator";
    public static final String BATTERY_CATEGORY = "battery";
    private Configuration configuration;
    private static Config instance;

    private Config() {
    }

    public static void init(Configuration configuration) {
        Config.getInstance().configuration = configuration;
        configuration.load();
        Class<Config> clazz = Config.class;
        for (Method method : clazz.getDeclaredMethods()) {
            String name = method.getName();
            if (method.getParameterCount() != 0 || !name.startsWith("get") || !name.endsWith("Property")) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            try {
                method.invoke((Object)Config.getInstance(), new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<String> solarGeneratorTierOder = new ArrayList<String>();
        ArrayList<String> batteryTierOrder = new ArrayList<String>();
        for (Tier tier : Tier.values()) {
            if (!tier.isDense()) {
                solarGeneratorTierOder.add(Config.getInstance().getSolarGeneratorMultiplierPropertyKey(tier));
                Config.getInstance().getSolarGeneratorMultiplierProperty(tier);
            }
            Config.getInstance().getBatteryMultiplierProperty(tier);
            batteryTierOrder.add(Config.getInstance().getBatteryPropertyKey(tier));
        }
        configuration.setCategoryPropertyOrder(SOLAR_GENERATOR_CATEGORY, solarGeneratorTierOder);
        configuration.setCategoryPropertyOrder(BATTERY_CATEGORY, batteryTierOrder);
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    private Property getLogLevelProperty() {
        return this.configuration.get(DEFAULT_CATEGORY, "logLevel", "INFO");
    }

    private Property getProduceWhileRainingProperty() {
        return this.configuration.get(SOLAR_GENERATOR_CATEGORY, "generatesWhileRaining", true, "Keeps generating energy when it's raining");
    }

    private Property getRealisticGenerationProperty() {
        return this.configuration.get(SOLAR_GENERATOR_CATEGORY, "realisticGeneration", false, "Enables realistic energy generation (which varies with available sunlight)");
    }

    private String getSolarGeneratorMultiplierPropertyKey(Tier tier) {
        String key = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, tier.name());
        key = key + "SolarGeneratorMultiplier";
        return key;
    }

    private Property getSolarGeneratorMultiplierProperty(Tier tier) {
        String key = this.getSolarGeneratorMultiplierPropertyKey(tier);
        return this.configuration.get(SOLAR_GENERATOR_CATEGORY, key, 1.0);
    }

    private String getBatteryPropertyKey(Tier tier) {
        String key = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, tier.name());
        key = key + "BatteryMultiplier";
        return key;
    }

    private Property getBatteryMultiplierProperty(Tier tier) {
        String key = this.getBatteryPropertyKey(tier);
        return this.configuration.get(BATTERY_CATEGORY, key, 1.0);
    }

    public Level getLogLevel() {
        return Level.valueOf((String)this.getLogLevelProperty().getString());
    }

    public void setLogLevel(Level level) {
        this.getLogLevelProperty().set(level.toString());
        this.configuration.save();
    }

    public boolean getProduceWhileRaining() {
        return this.getProduceWhileRainingProperty().getBoolean();
    }

    public boolean getRealisticGeneration() {
        return this.getRealisticGenerationProperty().getBoolean();
    }

    public double getSolarGeneratorMultiplier(Tier tier) {
        double multiplier = this.getSolarGeneratorMultiplierProperty(tier).getDouble();
        if (multiplier < 0.0) {
            multiplier = 0.0;
        }
        return multiplier;
    }

    public double getBatteryMultiplier(Tier tier) {
        double multiplier = this.getBatteryMultiplierProperty(tier).getDouble();
        if (multiplier < 0.0) {
            multiplier = 0.0;
        }
        return multiplier;
    }
}

