/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class EnergyFormatter {
    private static final NumberFormat format = new DecimalFormat("#0.00");
    private static final NumberFormat intFormat = new DecimalFormat("#0");
    private static final String[] suffixes = new String[]{"", "k", "M", "G", "T", "P", "E", "Z", "Y"};

    protected static double log1000(double value) {
        return Math.log10(value) / 3.0;
    }

    public static String format(double energy) {
        double exp;
        String unit = "FE";
        double absEnergy = Math.abs(energy);
        double d = exp = energy == 0.0 ? 0.0 : EnergyFormatter.log1000(absEnergy);
        if (absEnergy < 1.0) {
            return format.format(energy);
        }
        String suffix = "";
        int expInt = (int)Math.floor(exp);
        suffix = exp < (double)suffixes.length ? suffixes[expInt] : "x10^" + expInt * 3 + " ";
        double div = Math.pow(1000.0, expInt);
        double value = energy / div;
        return (expInt == 0 ? intFormat.format(value) : format.format(value)) + " " + suffix + unit;
    }
}

