/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.ItemStackHandler;

public class ItemStackHandlerWrapper
extends ItemStackHandler {
    private ItemStackHandler delegate;
    private HandlerType type;
    private List<SlotType> slotTypes;

    public ItemStackHandlerWrapper(ItemStackHandler stackHandler, HandlerType type, SlotType ... slotTypes) {
        this.delegate = stackHandler;
        this.type = type;
        this.slotTypes = Arrays.asList(slotTypes);
    }

    public static HandlerBuilder builder(ItemStackHandler delegate) {
        return new HandlerBuilderImpl(delegate);
    }

    public void setSize(int size) {
        this.delegate.setSize(size);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.delegate.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.delegate.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.delegate.getStackInSlot(slot);
    }

    public boolean canExtract(int slot) {
        SlotType slotType = this.slotTypes.get(slot);
        if (slotType == SlotType.INPUT) {
            return this.type == HandlerType.PLAYER || this.type == HandlerType.INTERNAL;
        }
        return this.type == HandlerType.PLAYER || this.type == HandlerType.CAPABILITY;
    }

    public boolean canInsert(int slot) {
        SlotType slotType = this.slotTypes.get(slot);
        if (slotType == SlotType.INPUT) {
            return this.type == HandlerType.PLAYER || this.type == HandlerType.CAPABILITY;
        }
        return this.type == HandlerType.INTERNAL;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.canInsert(slot)) {
            return stack.func_77946_l();
        }
        return this.delegate.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.canExtract(slot)) {
            return ItemStack.field_190927_a;
        }
        return this.delegate.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.delegate.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.delegate.isItemValid(slot, stack);
    }

    public NBTTagCompound serializeNBT() {
        return this.delegate.serializeNBT();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.delegate.deserializeNBT(nbt);
    }

    public static enum HandlerType {
        PLAYER,
        CAPABILITY,
        INTERNAL;

    }

    public static class HandlerBuilderImpl
    implements HandlerBuilder,
    FinalBuilder {
        private ItemStackHandler delegate;
        private HandlerType type;
        private List<SlotType> slots = new ArrayList<SlotType>();

        public HandlerBuilderImpl(ItemStackHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public FinalBuilder addSlot(SlotType slotType) {
            this.slots.add(slotType);
            return this;
        }

        @Override
        public ItemStackHandlerWrapper build() {
            SlotType[] slotsArray = this.slots.toArray(new SlotType[0]);
            return new ItemStackHandlerWrapper(this.delegate, this.type, slotsArray);
        }

        @Override
        public HandlerInitialSlotBuilder type(HandlerType type) {
            this.type = type;
            return this;
        }
    }

    public static enum SlotType {
        INPUT,
        OUTPUT;

    }

    public static interface FinalBuilder
    extends HandlerInitialSlotBuilder {
        public ItemStackHandlerWrapper build();
    }

    public static interface HandlerInitialSlotBuilder {
        public FinalBuilder addSlot(SlotType var1);
    }

    public static interface HandlerBuilder {
        public HandlerInitialSlotBuilder type(HandlerType var1);
    }
}

