/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy.blocks;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import paulojjj.solarenergy.blocks.EnergyNetworkBlock;
import paulojjj.solarenergy.gui.GuiHandler;
import paulojjj.solarenergy.registry.Blocks;
import paulojjj.solarenergy.tiles.EnergyCableTileEntity;

public class EnergyCable
extends EnergyNetworkBlock<EnergyCableTileEntity> {
    public EnergyCable() {
        this.configBuilder().resistance(1.0f).hardness(1.0f).gui(GuiHandler.GUI.ENERGY_CABLE).createTileEntity(x -> new EnergyCableTileEntity()).init();
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_184614_ca().func_77973_b() == Blocks.ENERGY_CABLE.getItemBlock()) {
            return false;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        EnergyCableTileEntity te = (EnergyCableTileEntity)worldIn.func_175625_s(pos);
        ArrayList<AxisAlignedBB> collisionBoxes = new ArrayList<AxisAlignedBB>();
        collisionBoxes.add(Boxes.CENTER.getBoundingBox());
        for (EnumFacing facing : EnumFacing.values()) {
            if (!te.hasStorage(facing)) continue;
            Boxes box = Boxes.getBox(facing);
            collisionBoxes.add(box.getBoundingBox());
        }
        AxisAlignedBB offsetEntityBox = entityBox.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        for (AxisAlignedBB collisionBox : collisionBoxes) {
            if (!offsetEntityBox.func_72326_a(collisionBox)) continue;
            collidingBoxes.add(collisionBox.func_186670_a(pos));
        }
    }

    @Deprecated
    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static enum Boxes {
        DOWN(new AxisAlignedBB(0.33, 0.0, 0.33, 0.67, 0.33, 0.67)),
        UP(new AxisAlignedBB(0.33, 0.67, 0.33, 0.67, 1.0, 0.67)),
        NORTH(new AxisAlignedBB(0.33, 0.33, 0.0, 0.67, 0.67, 0.33)),
        SOUTH(new AxisAlignedBB(0.33, 0.33, 0.67, 0.67, 0.67, 1.0)),
        WEST(new AxisAlignedBB(0.0, 0.33, 0.33, 0.33, 0.67, 0.67)),
        EAST(new AxisAlignedBB(0.67, 0.33, 0.33, 1.0, 0.67, 0.67)),
        CENTER(new AxisAlignedBB(0.33, 0.33, 0.33, 0.67, 0.67, 0.67));

        private AxisAlignedBB bb;

        private Boxes(AxisAlignedBB bb) {
            this.bb = bb;
        }

        public AxisAlignedBB getBoundingBox() {
            return this.bb;
        }

        public static Boxes getBox(EnumFacing facing) {
            return Boxes.values()[facing.ordinal()];
        }
    }
}

