/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy.net;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import paulojjj.solarenergy.Main;
import paulojjj.solarenergy.net.IMessageListener;
import paulojjj.solarenergy.net.MessageSerializer;

public class PacketManager {
    protected static SimpleNetworkWrapper wrapper;
    protected static MessageSerializer serializer;

    public static void init() {
        wrapper = NetworkRegistry.INSTANCE.newSimpleChannel("SolarEnergy");
        wrapper.registerMessage(TileEntityMessageHandler.class, TileEntityUpdateMessage.class, Message.TILE_ENTITY_MESSAGE.ordinal(), Side.CLIENT);
        wrapper.registerMessage(TileEntityMessageHandler.class, TileEntityUpdateMessage.class, Message.TILE_ENTITY_MESSAGE.ordinal(), Side.SERVER);
        wrapper.registerMessage(ContainerMessageHandler.class, ContainerUpdateMessage.class, Message.CONTAINER_UPDATE_MESSAGE.ordinal(), Side.CLIENT);
        wrapper.registerMessage(ContainerMessageHandler.class, ContainerUpdateMessage.class, Message.CONTAINER_UPDATE_MESSAGE.ordinal(), Side.SERVER);
    }

    public static Class<?> getGenericClass(IMessageListener<?> listener) {
        for (Class<?> listenerClass = listener.getClass(); listenerClass != null; listenerClass = listenerClass.getSuperclass()) {
            for (Type type : listenerClass.getGenericInterfaces()) {
                ParameterizedType pType;
                if (!(type instanceof ParameterizedType) || !(pType = (ParameterizedType)type).getRawType().equals(IMessageListener.class)) continue;
                return (Class)pType.getActualTypeArguments()[0];
            }
        }
        throw new RuntimeException("Could not get MessageListener generic class");
    }

    public static Object readMessage(IMessageListener<?> listener, GenericMessage message) {
        Class<?> messageClass = PacketManager.getGenericClass(listener);
        Object data = serializer.read(messageClass, message.getData());
        message.getData().release();
        return data;
    }

    public static void sendToAllTracking(TileEntity tileEntity, Object message) {
        int dimension = tileEntity.func_145831_w().field_73011_w.getDimension();
        BlockPos pos = tileEntity.func_174877_v();
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(dimension, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0);
        wrapper.sendToAllTracking((IMessage)new TileEntityUpdateMessage(tileEntity, message), point);
    }

    public static void sendTileEntityMessage(TileEntity tileEntity, EntityPlayerMP player, Object message) {
        wrapper.sendTo((IMessage)new TileEntityUpdateMessage(tileEntity, message), player);
    }

    public static void sendContainerUpdateMessage(EntityPlayerMP player, Object message) {
        wrapper.sendTo((IMessage)new ContainerUpdateMessage(message), player);
    }

    static {
        serializer = new MessageSerializer();
    }

    public static class TileEntityMessageHandler
    implements IMessageHandler<TileEntityUpdateMessage, IMessage> {
        private EntityPlayer getPlayer(MessageContext ctx) {
            return Main.getProxy().getFactory().getPlayerProvider().getPlayer(ctx);
        }

        public IMessage onMessage(TileEntityUpdateMessage message, MessageContext ctx) {
            EntityPlayer player = this.getPlayer(ctx);
            TileEntity tileEntity = player.func_130014_f_().func_175625_s(message.getPos());
            if (tileEntity instanceof IMessageListener) {
                Object tileMessage = PacketManager.readMessage((IMessageListener)tileEntity, message);
                ((IMessageListener)tileEntity).onMessage(tileMessage);
            }
            return null;
        }
    }

    public static class TileEntityUpdateMessage
    extends GenericMessage {
        private TileEntity tileEntity;
        private BlockPos pos;

        public TileEntityUpdateMessage() {
        }

        public TileEntityUpdateMessage(TileEntity tileEntity, Object message) {
            super(message);
            this.tileEntity = tileEntity;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            int x = buf.readInt();
            int y = buf.readInt();
            int z = buf.readInt();
            this.pos = new BlockPos(x, y, z);
            super.fromBytes(buf);
        }

        @Override
        public void toBytes(ByteBuf buf) {
            BlockPos pos = this.tileEntity.func_174877_v();
            buf.writeInt(pos.func_177958_n());
            buf.writeInt(pos.func_177956_o());
            buf.writeInt(pos.func_177952_p());
            super.toBytes(buf);
        }
    }

    public static enum Message {
        TILE_ENTITY_MESSAGE,
        CONTAINER_UPDATE_MESSAGE;

    }

    public static class ContainerMessageHandler
    implements IMessageHandler<ContainerUpdateMessage, IMessage> {
        private EntityPlayer getPlayer(MessageContext ctx) {
            return Main.getProxy().getFactory().getPlayerProvider().getPlayer(ctx);
        }

        public IMessage onMessage(ContainerUpdateMessage message, MessageContext ctx) {
            EntityPlayer player = this.getPlayer(ctx);
            Container container = player.field_71070_bA;
            if (container instanceof IMessageListener) {
                Object tileMessage = PacketManager.readMessage((IMessageListener)container, message);
                ((IMessageListener)container).onMessage(tileMessage);
            }
            return null;
        }
    }

    public static class ContainerUpdateMessage
    extends GenericMessage {
        public ContainerUpdateMessage() {
        }

        public ContainerUpdateMessage(Object message) {
            super(message);
        }
    }

    public static class GenericMessage
    implements IMessage {
        protected static MessageSerializer serializer = new MessageSerializer();
        protected Object message;
        protected ByteBuf data;

        public GenericMessage() {
        }

        public GenericMessage(Object message) {
            this.message = message;
        }

        public ByteBuf getData() {
            return this.data;
        }

        public void fromBytes(ByteBuf buf) {
            this.data = buf.copy();
        }

        public void toBytes(ByteBuf buf) {
            serializer.write(this.message, buf);
        }
    }
}

