/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy.networks;

import java.util.Map;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.IEnergyStorage;
import paulojjj.solarenergy.IUltraEnergyStorage;

public interface INetwork<T extends TileEntity>
extends IUltraEnergyStorage {
    public static <N extends INetwork<TE>, TE extends TileEntity> N newInstance(Class<N> networkClass, TE initialTile) {
        try {
            INetwork network = (INetwork)networkClass.newInstance();
            network.init(initialTile);
            return (N)network;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Error creating network", e);
        }
    }

    public INetwork<T> init(T var1);

    public Set<T> getTiles();

    public Map<T, Map<EnumFacing, IEnergyStorage>> getStorages();

    public Class<T> getTileClass();

    public boolean isValid();

    public void destroy();

    public void onBlockRemoved(T var1);

    public void onNeighborChanged(T var1, BlockPos var2);

    public void onChunkUnload(BlockPos var1);

    public void update();

    public double getEnergyInput();

    public double getEnergyOutput();
}

