/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy.renderers;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import paulojjj.solarenergy.renderers.Render;
import paulojjj.solarenergy.tiles.SolarGeneratorTileEntity;

@SideOnly(value=Side.CLIENT)
public class SolarGeneratorRenderer
extends TileEntitySpecialRenderer<SolarGeneratorTileEntity> {
    private static final ResourceLocation BOTTOM_TEXTURE = new ResourceLocation("solarenergy", "textures/blocks/solar_generator_bottom.png");
    private static final ResourceLocation SIDES_TEXTURE = new ResourceLocation("solarenergy", "textures/blocks/solar_generator_side.png");

    public void render(SolarGeneratorTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        RenderHelper.func_74519_b();
        GlStateManager.func_179140_f();
        GlStateManager.func_179089_o();
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        AxisAlignedBB bb = te.getRenderBoundingBox();
        double height = bb.field_72337_e - bb.field_72338_b;
        ResourceLocation topResource = TopResources.values()[te.getTier().ordinal()].resourceLocation;
        Render.drawCubeFaces(builder, topResource, 0.0, 0.0, 0.0, 1.0, height, 1.0, EnumFacing.UP);
        Render.drawCubeFaces(builder, BOTTOM_TEXTURE, 0.0, 0.0, 0.0, 1.0, height, 1.0, EnumFacing.DOWN);
        Render.drawCubeFaces(builder, SIDES_TEXTURE, 0.0, 0.0, 0.0, 1.0, height, 1.0, EnumFacing.field_176754_o);
        BlockPos pos = te.func_174877_v();
        GlStateManager.func_179129_p();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!te.hasStorage(facing)) continue;
            BlockPos neighborPos = pos.func_177972_a(facing);
            IBlockState bs = te.func_145831_w().func_180495_p(neighborPos);
            AxisAlignedBB bbNeighbor = bs.func_185900_c((IBlockAccess)te.func_145831_w(), neighborPos);
            if (bs.func_185913_b() || bbNeighbor.field_72337_e <= height) continue;
            double maxY = Math.min(1.0, bbNeighbor.field_72337_e + 0.1);
            Render.drawCubeFaces(builder, SIDES_TEXTURE, 0.001, 0.0, 0.001, 0.999, maxY, 0.999, facing);
        }
        GlStateManager.func_179121_F();
    }

    public static enum TopResources {
        BASIC,
        REGULAR,
        INTERMEDIATE,
        ADVANCED,
        ELITE,
        ULTIMATE;

        private ResourceLocation resourceLocation;

        private TopResources() {
            String tierName = this.name().toLowerCase();
            this.resourceLocation = new ResourceLocation("solarenergy", "textures/blocks/" + tierName + "_solar_generator_top.png");
        }
    }
}

