/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy.tiles;

import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import paulojjj.solarenergy.Config;
import paulojjj.solarenergy.IUltraEnergyStorage;
import paulojjj.solarenergy.Tier;
import paulojjj.solarenergy.networks.BatteryNetwork;
import paulojjj.solarenergy.tiles.EnergyNetworkTileEntity;

public class BatteryTileEntity
extends EnergyNetworkTileEntity
implements IUltraEnergyStorage,
ITickable {
    private Tier tier;

    public BatteryTileEntity() {
        this(Tier.BASIC);
    }

    public BatteryTileEntity(Tier tier) {
        this.setTier(tier);
    }

    protected void setTier(Tier tier) {
        this.tier = tier;
        int tierInt = tier.ordinal();
        this.setMaxUltraEnergyStored(Math.pow(10.0, tierInt < Tier.BASIC_DENSE.ordinal() ? (double)tierInt : (double)(tierInt + 2)) * 10000.0 * Config.getInstance().getBatteryMultiplier(tier));
        this.func_70296_d();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing == this.getOuputFacing()) {
            return (T)new OutputEnergyStorage();
        }
        return super.getCapability(capability, facing);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public EnumFacing getOuputFacing() {
        return (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockDirectional.field_176387_N);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        int tierValue = compound.func_74762_e("Tier");
        this.energy = compound.func_74769_h("Energy");
        Tier tier = Tier.values()[tierValue];
        this.setTier(tier);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("Tier", this.tier.ordinal());
        compound.func_74780_a("Energy", this.energy);
        return compound;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    @Override
    public Class<?> getNetworkClass() {
        return BatteryNetwork.class;
    }

    public class OutputEnergyStorage
    implements IUltraEnergyStorage {
        @Override
        public double receiveUltraEnergy(double maxReceive, boolean simulate) {
            return 0.0;
        }

        @Override
        public double extractUltraEnergy(double maxExtract, boolean simulate) {
            return BatteryTileEntity.this.delegate.extractUltraEnergy(maxExtract, simulate);
        }

        @Override
        public double getUltraEnergyStored() {
            return BatteryTileEntity.this.delegate.getUltraEnergyStored();
        }

        @Override
        public double getMaxUltraEnergyStored() {
            return BatteryTileEntity.this.delegate.getMaxUltraEnergyStored();
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return false;
        }
    }
}

