/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy.tiles;

import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.IEnergyStorage;
import paulojjj.solarenergy.Config;
import paulojjj.solarenergy.IEnergyProducer;
import paulojjj.solarenergy.TickHandler;
import paulojjj.solarenergy.Tier;
import paulojjj.solarenergy.networks.SolarGeneratorNetwork;
import paulojjj.solarenergy.tiles.EnergyNetworkTileEntity;

public class SolarGeneratorTileEntity
extends EnergyNetworkTileEntity
implements IEnergyProducer {
    private double maxProduction = 1.0;
    private double activeProduction = 0.0;
    private Tier tier;
    private boolean canSeeSky;
    private long nextSkyCheck;
    private static Random random = new Random();

    public SolarGeneratorTileEntity() {
        this(Tier.BASIC);
    }

    public SolarGeneratorTileEntity(Tier tier) {
        this.setTier(tier);
    }

    public Tier getTier() {
        return this.tier;
    }

    protected void setTier(Tier tier) {
        this.tier = tier;
        this.maxProduction = Math.pow(10.0, tier.ordinal()) * Config.getInstance().getSolarGeneratorMultiplier(tier);
        this.func_70296_d();
    }

    public double getMaxProduction() {
        return this.maxProduction;
    }

    public double getActiveProduction() {
        return this.activeProduction;
    }

    @Override
    public double getProduction() {
        return this.getActiveProduction();
    }

    @Override
    public double receiveUltraEnergy(double maxReceive, boolean simulate) {
        return 0.0;
    }

    @Override
    public double extractUltraEnergy(double maxExtract, boolean simulate) {
        double sent = Math.min(maxExtract, this.energy);
        if (!simulate) {
            this.energy -= sent;
        }
        return sent;
    }

    @Override
    public double getUltraEnergyStored() {
        return this.energy;
    }

    @Override
    public double getMaxUltraEnergyStored() {
        return this.maxProduction;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (facing == EnumFacing.UP) {
            return false;
        }
        return super.hasCapability(capability, facing);
    }

    protected boolean isSunActive() {
        long tick = TickHandler.getTick();
        if (!this.field_145850_b.func_72935_r()) {
            return false;
        }
        if (!Config.getInstance().getProduceWhileRaining() && this.field_145850_b.func_72896_J()) {
            return false;
        }
        if (tick >= this.nextSkyCheck) {
            this.nextSkyCheck = this.nextSkyCheck + (long)random.nextInt(100) + 1L;
            this.canSeeSky = this.field_145850_b.func_175678_i(this.func_174877_v().func_177972_a(EnumFacing.UP));
        }
        return this.canSeeSky;
    }

    public double productionByTick(long tick, double maxProduction) {
        if (maxProduction == 0.0) {
            return 0.0;
        }
        double hour = (double)((tick + 6000L) % 24000L) / 1000.0;
        double multiplier = (-4.0 * Math.pow(hour, 2.0) + 96.0 * hour - 407.0) / 169.0;
        if (multiplier <= 0.0) {
            return 0.0;
        }
        return multiplier * maxProduction;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K || !this.field_145850_b.func_175667_e(this.field_174879_c)) {
            return;
        }
        double d = this.activeProduction = this.isSunActive() ? this.maxProduction : 0.0;
        if (Config.getInstance().getRealisticGeneration()) {
            this.activeProduction = this.productionByTick(this.field_145850_b.func_72820_D(), this.activeProduction);
        }
        if (this.activeProduction > 0.0 && this.energy < this.getMaxUltraEnergyStored()) {
            this.energy += Math.min(this.activeProduction, this.getMaxUltraEnergyStored() - this.energy);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        int tierValue = compound.func_74762_e("Tier");
        Tier tier = Tier.values()[tierValue];
        this.setTier(tier);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("Tier", this.tier.ordinal());
        return compound;
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74768_a("Tier", this.tier.ordinal());
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        Tier tier = Tier.values()[tag.func_74762_e("Tier")];
        this.setTier(tier);
    }

    @Override
    public Class<?> getNetworkClass() {
        return SolarGeneratorNetwork.class;
    }

    @Override
    protected Object getContainerUpdateMessage() {
        double output = this.getNetwork().getEnergyOutput();
        double activeProduction = 0.0;
        double maxProduction = 0.0;
        for (SolarGeneratorTileEntity tile : this.getNetwork().getTiles()) {
            activeProduction += tile.getActiveProduction();
            maxProduction += tile.getMaxProduction();
        }
        return new SolarGeneratorContainerUpdateMessage(activeProduction, maxProduction, output);
    }

    @Override
    protected IEnergyStorage getNeighborStorage(EnumFacing facing) {
        IEnergyStorage storage = super.getNeighborStorage(facing);
        if (storage != null && storage instanceof SolarGeneratorTileEntity) {
            storage = null;
        }
        return storage;
    }

    public static class SolarGeneratorContainerUpdateMessage {
        public double activeProduction;
        public double maxProduction;
        public double output;
        public boolean sunActive;

        public SolarGeneratorContainerUpdateMessage() {
        }

        public SolarGeneratorContainerUpdateMessage(double activeProduction, double maxProduction, double output) {
            this.activeProduction = activeProduction;
            this.maxProduction = maxProduction;
            this.output = output;
        }
    }
}

