/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.type;

import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import team.chisel.ctm.api.texture.ITextureType;
import team.chisel.ctm.api.texture.TextureType;
import team.chisel.ctm.api.texture.TextureTypeList;

public class TextureTypeRegistry {
    private static Map<String, ITextureType> map = Maps.newHashMap();

    public static void preInit(FMLPreInitializationEvent event) {
        HashMultimap annots = HashMultimap.create();
        for (ASMDataTable.ASMData aSMData : event.getAsmData().getAll(TextureTypeList.class.getName())) {
            for (String value : ((List)aSMData.getAnnotationInfo().get("value")).stream().map(m -> (String)m.get("value")).collect(Collectors.toList())) {
                annots.put((Object)aSMData, (Object)value);
            }
        }
        for (ASMDataTable.ASMData aSMData : event.getAsmData().getAll(TextureType.class.getName())) {
            if (aSMData.getObjectName() == null) continue;
            annots.put((Object)aSMData, (Object)((String)aSMData.getAnnotationInfo().get("value")));
        }
        for (Map.Entry entry : annots.asMap().entrySet()) {
            ITextureType type;
            try {
                type = (ITextureType)Class.forName(((ASMDataTable.ASMData)entry.getKey()).getClassName()).newInstance();
            }
            catch (InstantiationException e) {
                try {
                    Class<?> c = Class.forName(((ASMDataTable.ASMData)entry.getKey()).getClassName());
                    type = (ITextureType)c.getDeclaredField(((ASMDataTable.ASMData)entry.getKey()).getObjectName()).get(null);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
                    throw Throwables.propagate((Throwable)e1);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException e) {
                throw Throwables.propagate((Throwable)e);
            }
            for (String name : (Collection)entry.getValue()) {
                if (StringUtils.func_151246_b((String)name)) {
                    name = ((ASMDataTable.ASMData)entry.getKey()).getObjectName();
                    name = name.substring(name.lastIndexOf(46) + 1);
                }
                TextureTypeRegistry.register(name, type);
            }
        }
    }

    public static void register(String name, ITextureType type) {
        String key = name.toLowerCase(Locale.ROOT);
        if (map.containsKey(key) && map.get(key) != type) {
            throw new IllegalArgumentException("Render Type with name " + key + " has already been registered!");
        }
        if (map.get(key) != type) {
            map.put(key, type);
        }
    }

    public static ITextureType getType(String name) {
        String key = name.toLowerCase(Locale.ROOT);
        return map.get(key);
    }

    public static boolean isValid(String name) {
        return TextureTypeRegistry.getType(name) != null;
    }
}

