/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.DisplayBlockEntity;
import com.supermartijn642.movingelevators.blocks.DisplayBlockEntityRenderer;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntityRenderer;
import com.supermartijn642.movingelevators.blocks.RemoteControllerBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import com.supermartijn642.movingelevators.gui.ElevatorScreen;
import com.supermartijn642.movingelevators.model.CamoBakedModel;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class MovingElevatorsClient {
    public static final ResourceLocation OVERLAY_TEXTURE_LOCATION = new ResourceLocation("movingelevators", "blocks/block_overlays");
    public static TextureAtlasSprite OVERLAY_SPRITE;

    @SubscribeEvent
    public static void setup(RegistryEvent.Register<Block> e) {
        ClientRegistry.bindTileEntitySpecialRenderer(ControllerBlockEntity.class, new ElevatorInputBlockEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(DisplayBlockEntity.class, (TileEntitySpecialRenderer)new DisplayBlockEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(RemoteControllerBlockEntity.class, new ElevatorInputBlockEntityRenderer());
    }

    @SubscribeEvent
    public static void onColorHandlerEvent(ColorHandlerEvent.Block e) {
        e.getBlockColors().func_186722_a((state, blockAndTintGetter, pos, p_92570_) -> {
            if (blockAndTintGetter == null || pos == null) {
                return 0;
            }
            TileEntity entity = blockAndTintGetter.func_175625_s(pos);
            return entity instanceof CamoBlockEntity && ((CamoBlockEntity)entity).hasCamoState() ? ClientUtils.getMinecraft().func_184125_al().func_186724_a(((CamoBlockEntity)entity).getCamoState(), blockAndTintGetter, pos, p_92570_) : 0;
        }, new Block[]{MovingElevators.elevator_block, MovingElevators.display_block, MovingElevators.button_block});
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent e) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MovingElevators.elevator_block), (int)0, (ModelResourceLocation)new ModelResourceLocation(MovingElevators.elevator_block.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MovingElevators.display_block), (int)0, (ModelResourceLocation)new ModelResourceLocation(MovingElevators.display_block.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MovingElevators.button_block), (int)0, (ModelResourceLocation)new ModelResourceLocation(MovingElevators.button_block.getRegistryName(), "inventory"));
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent e) {
        MovingElevatorsClient.setCamouflageModel(e, (Block)MovingElevators.elevator_block);
        MovingElevatorsClient.setCamouflageModel(e, (Block)MovingElevators.display_block);
        MovingElevatorsClient.setCamouflageModel(e, (Block)MovingElevators.button_block);
    }

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre e) {
        if (e.getMap() == ClientUtils.getTextureManager().func_110581_b(TextureMap.field_110575_b)) {
            OVERLAY_SPRITE = e.getMap().func_174942_a(OVERLAY_TEXTURE_LOCATION);
        }
    }

    private static void setCamouflageModel(ModelBakeEvent e, Block block) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            StringBuilder builder = new StringBuilder();
            if (!state.func_177228_b().isEmpty()) {
                builder.append(state.func_177228_b().entrySet().stream().map(entry -> MovingElevatorsClient.getPropertyName((IProperty)entry.getKey(), (Comparable)entry.getValue())).collect(Collectors.joining(",")));
            } else {
                builder.append("normal");
            }
            ModelResourceLocation modelLocation = new ModelResourceLocation(block.getRegistryName(), builder.toString());
            IBakedModel model = e.getModelManager().func_174953_a(modelLocation);
            e.getModelRegistry().func_82595_a((Object)modelLocation, (Object)new CamoBakedModel(model));
        }
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> value) {
        return property.func_177701_a() + "=" + property.func_177702_a(value);
    }

    public static void openElevatorScreen(BlockPos pos) {
        ClientUtils.displayScreen((GuiScreen)new ElevatorScreen(pos));
    }

    public static String formatFloorDisplayName(String name, int floor) {
        return name == null ? TextComponents.translation((String)"movingelevators.floor_name", (Object[])new Object[]{TextComponents.number((int)floor).get()}).format() : name;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END && !Minecraft.func_71410_x().func_147113_T() && Minecraft.func_71410_x().field_71441_e != null) {
            ElevatorGroupCapability.tickWorldCapability((World)Minecraft.func_71410_x().field_71441_e);
        }
    }
}

