/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.block.BaseTileEntity;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.blocks.CamoBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public abstract class CamoBlockEntity
extends BaseTileEntity {
    private IBlockState camoState = Blocks.field_150350_a.func_176223_P();

    public boolean setCamoState(IBlockState state) {
        this.camoState = state == null ? Blocks.field_150350_a.func_176223_P() : state;
        this.dataChanged();
        this.field_145850_b.func_175664_x(this.field_174879_c);
        return true;
    }

    public IBlockState getCamoState() {
        return this.camoState;
    }

    public boolean hasCamoState() {
        return this.camoState != null && this.camoState.func_177230_c() != Blocks.field_150350_a && !(this.camoState.func_177230_c() instanceof CamoBlock);
    }

    public boolean canBeCamoStack(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlock)) {
            return false;
        }
        Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
        return !MovingElevators.CAMOUFLAGE_MOD_BLACKLIST.contains(block.getRegistryName().func_110624_b()) && this.isFullCube(block.func_176223_P());
    }

    private boolean isFullCube(IBlockState state) {
        for (EnumFacing side : EnumFacing.values()) {
            if (state.func_193401_d((IBlockAccess)this.field_145850_b, this.field_174879_c, side) == BlockFaceShape.SOLID) continue;
            return false;
        }
        return true;
    }

    protected NBTTagCompound writeData() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("camoState", Block.func_176210_f((IBlockState)this.camoState));
        return compound;
    }

    protected void readData(NBTTagCompound compound) {
        ItemStack camoStack;
        Item item;
        if (compound.func_74764_b("camoState")) {
            this.camoState = Block.func_176220_d((int)compound.func_74762_e("camoState"));
        } else if (compound.func_74764_b("hasCamo")) {
            this.camoState = compound.func_74767_n("hasCamo") ? Block.func_176220_d((int)compound.func_74762_e("camo")) : Blocks.field_150350_a.func_176223_P();
        } else if (compound.func_74764_b("camo") && (item = (camoStack = new ItemStack(compound.func_74775_l("camo"))).func_77973_b()) instanceof ItemBlock) {
            Block block = ((ItemBlock)item).func_179223_d();
            this.camoState = block.func_176223_P();
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        if (nbt.func_150297_b("info", 10)) {
            nbt.func_74782_a("data", (NBTBase)nbt.func_74775_l("info"));
            nbt.func_82580_o("info");
        }
        super.func_145839_a(nbt);
    }
}

