/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.movingelevators.blocks.ControllerBlock;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class ControllerBlockEntity
extends ElevatorInputBlockEntity {
    private boolean initialized = false;
    private EnumFacing facing;
    private String name;
    private EnumDyeColor color = EnumDyeColor.GRAY;
    private boolean showButtons = true;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.initialized) {
            ElevatorGroupCapability groupCapability = (ElevatorGroupCapability)this.field_145850_b.getCapability(ElevatorGroupCapability.CAPABILITY, null);
            if (groupCapability != null) {
                groupCapability.add(this);
            }
            this.getGroup().updateFloorData(this, this.name, this.color);
            this.initialized = true;
        }
    }

    @Override
    public EnumFacing getFacing() {
        if (this.facing == null) {
            this.facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)ControllerBlock.FACING);
        }
        return this.facing;
    }

    @Override
    protected NBTTagCompound writeData() {
        NBTTagCompound compound = super.writeData();
        compound.func_74757_a("hasName", this.name != null);
        if (this.name != null) {
            compound.func_74778_a("name", this.name);
        }
        compound.func_74768_a("color", this.color.func_176765_a());
        compound.func_74757_a("showButtons", this.showButtons);
        return compound;
    }

    @Override
    protected void readData(NBTTagCompound compound) {
        super.readData(compound);
        this.name = compound.func_150297_b("hasName", 1) ? (compound.func_74767_n("hasName") ? compound.func_74779_i("name") : null) : (compound.func_150297_b("name", 8) ? compound.func_74779_i("name") : null);
        this.color = EnumDyeColor.func_176764_b((int)compound.func_74762_e("color"));
        this.showButtons = !compound.func_150297_b("showButtons", 1) || compound.func_74767_n("showButtons");
    }

    public void onBreak() {
        ElevatorGroupCapability groups;
        if (!this.field_145850_b.field_72995_K && (groups = (ElevatorGroupCapability)this.field_145850_b.getCapability(ElevatorGroupCapability.CAPABILITY, null)) != null) {
            groups.remove(this);
        }
    }

    @Override
    public String getFloorName() {
        return this.name;
    }

    public void setFloorName(String name) {
        this.name = name;
        this.dataChanged();
        if (this.hasGroup()) {
            this.getGroup().updateFloorData(this, this.name, this.color);
        }
    }

    public void setDisplayLabelColor(EnumDyeColor color) {
        this.color = color;
        this.dataChanged();
        if (this.hasGroup()) {
            this.getGroup().updateFloorData(this, this.name, this.color);
        }
    }

    @Override
    public EnumDyeColor getDisplayLabelColor() {
        return this.color;
    }

    public boolean shouldShowButtons() {
        return this.showButtons;
    }

    public void toggleShowButtons() {
        this.showButtons = !this.showButtons;
        this.dataChanged();
    }

    @Override
    public ElevatorGroup getGroup() {
        ElevatorGroupCapability groups = (ElevatorGroupCapability)this.field_145850_b.getCapability(ElevatorGroupCapability.CAPABILITY, null);
        return groups == null ? null : groups.getGroup(this);
    }

    @Override
    public boolean hasGroup() {
        return this.initialized;
    }

    @Override
    public int getFloorLevel() {
        return this.field_174879_c.func_177956_o();
    }
}

