/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlock;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.blocks.RemoteControllerBlockEntity;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;

public class RemoteControllerBlock
extends ElevatorInputBlock {
    public RemoteControllerBlock(String registryName, BaseBlock.Properties properties) {
        super(registryName, properties, (Supplier<? extends ElevatorInputBlockEntity>)((Supplier<ElevatorInputBlockEntity>)RemoteControllerBlockEntity::new));
    }

    @Override
    protected boolean onRightClick(IBlockState state, World worldIn, CamoBlockEntity blockEntity, BlockPos pos, EntityPlayer player, EnumHand handIn, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (super.onRightClick(state, worldIn, blockEntity, pos, player, handIn, facing, hitX, hitY, hitZ)) {
            return true;
        }
        if (blockEntity instanceof RemoteControllerBlockEntity) {
            if (worldIn.field_72995_K) {
                BlockPos controllerPos = ((RemoteControllerBlockEntity)blockEntity).getControllerPos();
                ITextComponent x = TextComponents.number((int)controllerPos.func_177958_n()).color(TextFormatting.GOLD).get();
                ITextComponent y = TextComponents.number((int)controllerPos.func_177956_o()).color(TextFormatting.GOLD).get();
                ITextComponent z = TextComponents.number((int)controllerPos.func_177952_p()).color(TextFormatting.GOLD).get();
                player.func_146105_b(TextComponents.translation((String)"movingelevators.remote_controller.controller_location", (Object[])new Object[]{x, y, z}).get(), true);
            }
            return true;
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof RemoteControllerBlockEntity) {
            NBTTagCompound compound = stack.func_77978_p();
            if (compound == null || !compound.func_74764_b("controllerDim")) {
                return;
            }
            ((RemoteControllerBlockEntity)tile).setValues(placer.func_174811_aO().func_176734_d(), new BlockPos(compound.func_74762_e("controllerX"), compound.func_74762_e("controllerY"), compound.func_74762_e("controllerZ")));
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable World reader, List<String> tooltips, ITooltipFlag advanced) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b("controllerDim")) {
            tooltips.add(TextComponents.translation((String)"movingelevators.remote_controller.tooltip").color(TextFormatting.AQUA).format());
        } else {
            ITextComponent x = TextComponents.number((int)tag.func_74762_e("controllerX")).color(TextFormatting.GOLD).get();
            ITextComponent y = TextComponents.number((int)tag.func_74762_e("controllerY")).color(TextFormatting.GOLD).get();
            ITextComponent z = TextComponents.number((int)tag.func_74762_e("controllerZ")).color(TextFormatting.GOLD).get();
            ITextComponent dimension = TextComponents.dimension((DimensionType)DimensionType.func_186069_a((int)tag.func_74762_e("controllerDim"))).color(TextFormatting.GOLD).get();
            tooltips.add(TextComponents.translation((String)"movingelevators.remote_controller.tooltip.bound", (Object[])new Object[]{x, y, z, dimension}).format());
        }
        super.func_190948_a(stack, reader, tooltips, advanced);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof RemoteControllerBlockEntity) {
            ((RemoteControllerBlockEntity)tile).onBreak();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        Object entity = world.func_175625_s(pos);
        if (entity instanceof RemoteControllerBlockEntity && (entity = ((RemoteControllerBlockEntity)((Object)entity)).getController()) != null && ((ControllerBlockEntity)((Object)entity)).hasGroup() && ((ControllerBlockEntity)((Object)entity)).getGroup().isCageAvailableAt((ControllerBlockEntity)((Object)entity))) {
            return 15;
        }
        return 0;
    }
}

