/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class RemoteControllerBlockEntity
extends ElevatorInputBlockEntity
implements ITickable {
    private EnumFacing facing = EnumFacing.NORTH;
    private BlockPos controllerPos = BlockPos.field_177992_a;
    private int groupCheckCounter = 0;
    private ElevatorGroup lastGroup;

    @Override
    public void func_73660_a() {
        ElevatorGroup group;
        super.func_73660_a();
        ++this.groupCheckCounter;
        if (this.groupCheckCounter == 40 && (group = this.getGroup()) != this.lastGroup) {
            this.field_145850_b.func_175666_e(this.field_174879_c, this.getBlockState().func_177230_c());
            group.addComparatorListener(this.getFloorLevel(), this.field_174879_c);
            this.lastGroup = group;
        }
    }

    public void setValues(EnumFacing facing, BlockPos controllerPos) {
        this.facing = facing;
        this.controllerPos = controllerPos;
        this.dataChanged();
    }

    @Override
    protected NBTTagCompound writeData() {
        NBTTagCompound compound = super.writeData();
        compound.func_74768_a("facing", this.facing.func_176745_a());
        compound.func_74768_a("controllerX", this.controllerPos.func_177958_n());
        compound.func_74768_a("controllerY", this.controllerPos.func_177956_o());
        compound.func_74768_a("controllerZ", this.controllerPos.func_177952_p());
        return compound;
    }

    @Override
    protected void readData(NBTTagCompound compound) {
        super.readData(compound);
        this.facing = EnumFacing.func_82600_a((int)compound.func_74762_e("facing"));
        this.controllerPos = new BlockPos(compound.func_74762_e("controllerX"), compound.func_74762_e("controllerY"), compound.func_74762_e("controllerZ"));
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    public ControllerBlockEntity getController() {
        if (this.field_145850_b == null || this.controllerPos == null) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.controllerPos);
        return tile instanceof ControllerBlockEntity ? (ControllerBlockEntity)tile : null;
    }

    @Override
    public boolean hasGroup() {
        ControllerBlockEntity controller = this.getController();
        return controller != null && controller.hasGroup();
    }

    @Override
    public ElevatorGroup getGroup() {
        ControllerBlockEntity controller = this.getController();
        return controller == null ? null : controller.getGroup();
    }

    @Override
    public String getFloorName() {
        ControllerBlockEntity controller = this.getController();
        return controller == null ? null : controller.getFloorName();
    }

    @Override
    public EnumDyeColor getDisplayLabelColor() {
        ControllerBlockEntity controller = this.getController();
        return controller == null ? null : controller.getDisplayLabelColor();
    }

    @Override
    public int getFloorLevel() {
        return this.controllerPos.func_177956_o();
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public void onBreak() {
        ElevatorGroup group = this.getGroup();
        if (group != null) {
            group.removeComparatorListener(this.field_174879_c);
        }
    }
}

