/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.google.common.collect.Streams;
import com.supermartijn642.core.block.BlockShape;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class ElevatorCage {
    public final int xSize;
    public final int ySize;
    public final int zSize;
    public final IBlockState[][][] blockStates;
    public final BlockShape shape;
    public final List<AxisAlignedBB> collisionBoxes;
    public final AxisAlignedBB bounds;

    public static ElevatorCage createCageAndClear(World world, BlockPos startPos, int xSize, int ySize, int zSize) {
        BlockPos pos;
        int z;
        int y;
        int x;
        if (!ElevatorCage.canCreateCage(world, startPos, xSize, ySize, zSize)) {
            return null;
        }
        IBlockState[][][] states = new IBlockState[xSize][ySize][zSize];
        BlockShape shape = BlockShape.empty();
        for (x = 0; x < xSize; ++x) {
            for (y = 0; y < ySize; ++y) {
                for (z = 0; z < zSize; ++z) {
                    pos = startPos.func_177982_a(x, y, z);
                    if (world.func_175623_d(pos)) continue;
                    states[x][y][z] = world.func_180495_p(pos);
                    AxisAlignedBB boundingBox = states[x][y][z].func_185890_d((IBlockAccess)world, pos);
                    BlockShape blockShape = boundingBox == null ? BlockShape.empty() : BlockShape.create((AxisAlignedBB)boundingBox);
                    blockShape = blockShape.offset((double)x, (double)y, (double)z);
                    shape = BlockShape.or((BlockShape)shape, (BlockShape[])new BlockShape[]{blockShape});
                }
            }
        }
        for (x = 0; x < xSize; ++x) {
            for (y = 0; y < ySize; ++y) {
                for (z = 0; z < zSize; ++z) {
                    pos = startPos.func_177982_a(x, y, z);
                    if (states[x][y][z] == null) continue;
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 20);
                }
            }
        }
        for (x = 0; x < xSize; ++x) {
            for (y = 0; y < ySize; ++y) {
                for (z = 0; z < zSize; ++z) {
                    pos = startPos.func_177982_a(x, y, z);
                    if (states[x][y][z] == null) continue;
                    world.markAndNotifyBlock(pos, world.func_72863_F().func_186026_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4), states[x][y][z], world.func_180495_p(pos), 3);
                }
            }
        }
        return new ElevatorCage(xSize, ySize, zSize, states, shape.toBoxes());
    }

    public static boolean canCreateCage(World world, BlockPos startPos, int xSize, int ySize, int zSize) {
        boolean hasBlocks = false;
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    if (world.func_175623_d(startPos.func_177982_a(x, y, z))) continue;
                    if (!ElevatorCage.canBlockBeInCage(world, startPos.func_177982_a(x, y, z))) {
                        return false;
                    }
                    hasBlocks = true;
                }
            }
        }
        return hasBlocks;
    }

    public static boolean canBlockBeInCage(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return !(state.func_177230_c() instanceof IFluidBlock) && state.func_185887_b(world, pos) >= 0.0f && !state.func_177230_c().hasTileEntity(state);
    }

    public ElevatorCage(int xSize, int ySize, int zSize, IBlockState[][][] states, List<AxisAlignedBB> collisionBoxes) {
        if (states.length != xSize || states[0].length != ySize || states[0][0].length != zSize) {
            throw new IllegalArgumentException("Given size and block state array do not match!");
        }
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.blockStates = states;
        this.collisionBoxes = Collections.unmodifiableList(collisionBoxes);
        BlockShape shape = BlockShape.empty();
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        for (AxisAlignedBB box : collisionBoxes) {
            shape = BlockShape.or((BlockShape)shape, (BlockShape[])new BlockShape[]{BlockShape.create((AxisAlignedBB)box)});
            minX = Math.min(minX, box.field_72340_a);
            minY = Math.min(minY, box.field_72338_b);
            minZ = Math.min(minZ, box.field_72339_c);
            maxX = Math.max(maxX, box.field_72336_d);
            maxY = Math.max(maxY, box.field_72337_e);
            maxZ = Math.max(maxZ, box.field_72334_f);
        }
        this.shape = shape;
        this.bounds = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void place(World world, BlockPos startPos) {
        int z;
        int y;
        int x;
        for (x = 0; x < this.xSize; ++x) {
            for (y = 0; y < this.ySize; ++y) {
                for (z = 0; z < this.zSize; ++z) {
                    IBlockState state = this.blockStates[x][y][z];
                    if (state == null) continue;
                    BlockPos pos = startPos.func_177982_a(x, y, z);
                    if (world.func_175623_d(pos)) {
                        world.func_175656_a(pos, state);
                        continue;
                    }
                    if (world.func_180495_p(pos).func_185887_b(world, pos) >= 0.0f) {
                        world.func_175655_b(pos, true);
                        world.func_175656_a(pos, state);
                        continue;
                    }
                    InventoryHelper.func_180173_a((World)world, (double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)new ItemStack(state.func_177230_c()));
                }
            }
        }
        for (x = 0; x < this.xSize; ++x) {
            for (y = 0; y < this.ySize; ++y) {
                for (z = 0; z < this.zSize; ++z) {
                    BlockPos neighbor;
                    EnumFacing direction;
                    BlockPos pos = startPos.func_177982_a(x, y, z);
                    IBlockState state = world.func_180495_p(pos);
                    if (x == 0) {
                        direction = EnumFacing.WEST;
                        neighbor = pos.func_177972_a(direction);
                        state.func_189546_a(world, pos, state.func_177230_c(), neighbor);
                        world.func_175685_c(pos, state.func_177230_c(), false);
                    }
                    if (x == this.xSize - 1) {
                        direction = EnumFacing.EAST;
                        neighbor = pos.func_177972_a(direction);
                        state.func_189546_a(world, pos, state.func_177230_c(), neighbor);
                        world.func_175685_c(pos, state.func_177230_c(), false);
                    }
                    if (y == 0) {
                        direction = EnumFacing.DOWN;
                        neighbor = pos.func_177972_a(direction);
                        state.func_189546_a(world, pos, state.func_177230_c(), neighbor);
                        world.func_175685_c(pos, state.func_177230_c(), false);
                    }
                    if (y == this.ySize - 1) {
                        direction = EnumFacing.UP;
                        neighbor = pos.func_177972_a(direction);
                        state.func_189546_a(world, pos, state.func_177230_c(), neighbor);
                        world.func_175685_c(pos, state.func_177230_c(), false);
                    }
                    if (z == 0) {
                        direction = EnumFacing.NORTH;
                        neighbor = pos.func_177972_a(direction);
                        state.func_189546_a(world, pos, state.func_177230_c(), neighbor);
                        world.func_175685_c(pos, state.func_177230_c(), false);
                    }
                    if (z == this.zSize - 1) {
                        direction = EnumFacing.SOUTH;
                        neighbor = pos.func_177972_a(direction);
                        state.func_189546_a(world, pos, state.func_177230_c(), neighbor);
                        world.func_175685_c(pos, state.func_177230_c(), false);
                    }
                    if (world.field_72995_K || !(state.func_177230_c() instanceof BlockButton) || !((Boolean)state.func_177229_b((IProperty)BlockButton.field_176584_b)).booleanValue()) continue;
                    state.func_177230_c().func_180650_b(world, pos, state, world.field_73012_v);
                }
            }
        }
    }

    public NBTTagCompound write() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("xSize", this.xSize);
        compound.func_74768_a("ySize", this.ySize);
        compound.func_74768_a("zSize", this.zSize);
        int[] stateIds = new int[this.xSize * this.ySize * this.zSize];
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                for (int z = 0; z < this.zSize; ++z) {
                    int index = x * this.ySize * this.zSize + y * this.zSize + z;
                    IBlockState state = this.blockStates[x][y][z];
                    stateIds[index] = Block.func_176210_f((IBlockState)(state == null ? Blocks.field_150350_a.func_176223_P() : state));
                }
            }
        }
        compound.func_74783_a("blockStates", stateIds);
        NBTTagList collisionBoxList = new NBTTagList();
        this.collisionBoxes.forEach(box -> collisionBoxList.func_74742_a((NBTBase)ElevatorCage.writeBox(box)));
        compound.func_74782_a("collisionBoxes", (NBTBase)collisionBoxList);
        return compound;
    }

    public static ElevatorCage read(NBTTagCompound compound) {
        int xSize = compound.func_74762_e("xSize");
        int ySize = compound.func_74762_e("ySize");
        int zSize = compound.func_74762_e("zSize");
        int[] stateIds = compound.func_74759_k("blockStates");
        IBlockState[][][] blockStates = new IBlockState[xSize][ySize][zSize];
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    int index = x * ySize * zSize + y * zSize + z;
                    IBlockState state = Block.func_176220_d((int)stateIds[index]);
                    blockStates[x][y][z] = state.func_177230_c() == Blocks.field_150350_a ? null : state;
                }
            }
        }
        NBTTagList collisionBoxList = compound.func_150295_c("collisionBoxes", 10);
        List<AxisAlignedBB> collisionBoxes = Streams.stream((Iterable)collisionBoxList).map(NBTTagCompound.class::cast).map(ElevatorCage::readBox).collect(Collectors.toList());
        return new ElevatorCage(xSize, ySize, zSize, blockStates, collisionBoxes);
    }

    private static NBTTagCompound writeBox(AxisAlignedBB box) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74780_a("x1", box.field_72340_a);
        compound.func_74780_a("y1", box.field_72338_b);
        compound.func_74780_a("z1", box.field_72339_c);
        compound.func_74780_a("x2", box.field_72336_d);
        compound.func_74780_a("y2", box.field_72337_e);
        compound.func_74780_a("z2", box.field_72334_f);
        return compound;
    }

    private static AxisAlignedBB readBox(NBTTagCompound compound) {
        return new AxisAlignedBB(compound.func_74769_h("x1"), compound.func_74769_h("y1"), compound.func_74769_h("z1"), compound.func_74769_h("x2"), compound.func_74769_h("y2"), compound.func_74769_h("z2"));
    }
}

