/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.elevator.ElevatorFallDamageHandler;
import com.supermartijn642.movingelevators.packets.PacketOnElevator;
import java.util.List;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ElevatorCollisionHandler {
    public static void handleEntityCollisions(World world, AxisAlignedBB bounds, List<AxisAlignedBB> boundingBoxes, Vec3d position, Vec3d motion) {
        bounds = bounds.func_191194_a(position);
        bounds = new AxisAlignedBB(bounds.field_72340_a, bounds.field_72338_b + Math.min(0.0, motion.field_72448_b), bounds.field_72339_c, bounds.field_72336_d, bounds.field_72337_e + Math.max(0.0, motion.field_72448_b), bounds.field_72334_f);
        bounds = bounds.func_186662_g(2.0);
        List entities = world.func_175674_a(null, bounds, ElevatorCollisionHandler::canCollideWith);
        for (Entity entity : entities) {
            for (AxisAlignedBB box : boundingBoxes) {
                box = box.func_191194_a(position);
                ElevatorCollisionHandler.handleHorizontalCollision(entity, box);
            }
            for (AxisAlignedBB box : boundingBoxes) {
                box = box.func_191194_a(position);
                ElevatorCollisionHandler.handleVerticalCollision(entity, box, motion);
            }
        }
    }

    private static void handleHorizontalCollision(Entity entity, AxisAlignedBB box) {
        Vec3d entityPos = entity.func_174791_d();
        Vec3d oldEntityPos = new Vec3d(entity.field_70169_q, entity.field_70167_r, entity.field_70166_s);
        Vec3d entityMotion = entityPos.func_178788_d(oldEntityPos);
        AxisAlignedBB entityBox = entity.func_174813_aQ().func_186664_h(1.0E-7);
        AxisAlignedBB oldEntityBox = entity.func_174813_aQ().func_186664_h(1.0E-7).func_72317_d(-entityMotion.field_72450_a, 0.0, -entityMotion.field_72449_c);
        if (oldEntityBox.field_72337_e > box.field_72338_b && oldEntityBox.field_72338_b < box.field_72337_e) {
            if (oldEntityBox.field_72336_d > box.field_72340_a && oldEntityBox.field_72340_a < box.field_72336_d) {
                if (oldEntityBox.field_72334_f < box.field_72339_c && entityBox.field_72334_f > box.field_72339_c) {
                    entity.func_70107_b(entityPos.field_72450_a, entityPos.field_72448_b, box.field_72339_c - (double)(entity.field_70130_N / 2.0f));
                    entity.field_70179_y = 0.0;
                } else if (oldEntityBox.field_72339_c > box.field_72334_f && entityBox.field_72339_c < box.field_72334_f) {
                    entity.func_70107_b(entityPos.field_72450_a, entityPos.field_72448_b, box.field_72334_f + (double)(entity.field_70130_N / 2.0f));
                    entity.field_70179_y = 0.0;
                }
            } else if (oldEntityBox.field_72334_f > box.field_72339_c && oldEntityBox.field_72339_c < box.field_72334_f) {
                if (oldEntityBox.field_72336_d < box.field_72340_a && entityBox.field_72336_d > box.field_72340_a) {
                    entity.func_70107_b(box.field_72340_a - (double)(entity.field_70130_N / 2.0f), entityPos.field_72448_b, entityPos.field_72449_c);
                    entity.field_70159_w = 0.0;
                } else if (oldEntityBox.field_72340_a > box.field_72336_d && entityBox.field_72340_a < box.field_72336_d) {
                    entity.func_70107_b(box.field_72336_d + (double)(entity.field_70130_N / 2.0f), entityPos.field_72448_b, entityPos.field_72449_c);
                    entity.field_70159_w = 0.0;
                }
            }
        }
    }

    private static void handleVerticalCollision(Entity entity, AxisAlignedBB box, Vec3d motion) {
        AxisAlignedBB newBox = box.func_191194_a(motion);
        boolean movingUp = motion.field_72448_b > 0.0;
        Vec3d entityPos = entity.func_174791_d();
        Vec3d oldEntityPos = new Vec3d(entity.field_70169_q, entity.field_70167_r, entity.field_70166_s);
        Vec3d entityMotion = entityPos.func_178788_d(oldEntityPos);
        AxisAlignedBB entityBox = entity.func_174813_aQ().func_186664_h(1.0E-7);
        AxisAlignedBB oldEntityBox = entity.func_174813_aQ().func_186664_h(1.0E-7).func_72317_d(-entityMotion.field_72450_a, -entityMotion.field_72448_b, -entityMotion.field_72449_c);
        if (oldEntityBox.field_72336_d > box.field_72340_a && oldEntityBox.field_72340_a < box.field_72336_d && oldEntityBox.field_72334_f > box.field_72339_c && oldEntityBox.field_72339_c < box.field_72334_f) {
            if (oldEntityBox.field_72337_e < box.field_72338_b && entityBox.field_72337_e > newBox.field_72338_b) {
                entity.func_70107_b(entityPos.field_72450_a, newBox.field_72338_b - (double)entity.field_70130_N, entityPos.field_72449_c);
                entity.field_70181_x = 0.0;
            } else if (oldEntityBox.field_72338_b > box.field_72337_e && (entityBox.field_72338_b < newBox.field_72337_e || !movingUp && ElevatorCollisionHandler.canPullEntity(entity) && oldEntityBox.field_72338_b > box.field_72337_e && oldEntityBox.field_72338_b < box.field_72337_e + 0.1)) {
                entity.func_70107_b(entityPos.field_72450_a, newBox.field_72337_e, entityPos.field_72449_c);
                entity.field_70181_x = 0.0;
                entity.field_70122_E = true;
                entity.func_180430_e(entity.field_70143_R, 1.0f);
                entity.field_70143_R = 0.0f;
                if (entity instanceof EntityPlayer) {
                    ElevatorFallDamageHandler.resetElevatorTime((EntityPlayer)entity);
                    if (entity.field_70170_p.field_72995_K) {
                        MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketOnElevator());
                    }
                }
            }
        }
    }

    private static boolean canCollideWith(Entity entity) {
        return (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_175149_v()) && entity.func_70067_L() && !entity.func_184218_aH() && entity.func_184192_z() == EnumPushReaction.NORMAL;
    }

    private static boolean canPullEntity(Entity entity) {
        return entity.field_70181_x <= 0.0 && !entity.func_189652_ae();
    }
}

