/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.MovingElevatorsConfig;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorCollisionHandler;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import com.supermartijn642.movingelevators.packets.PacketSyncElevatorMovement;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ElevatorGroup {
    private static final int RE_SYNC_INTERVAL = 10;
    private static final double ACCELERATION = 0.05;
    public final World world;
    public final int x;
    public final int z;
    public final EnumFacing facing;
    private boolean isMoving = false;
    private int targetY;
    private double lastY;
    private double currentY;
    private double syncCurrentY = 2.147483647E9;
    private double targetSpeed = 0.2;
    private double speed = 0.0;
    private int cageSideOffset = 0;
    private int cageDepthOffset = 0;
    private int cageHeightOffset = -1;
    private int cageSizeX = 3;
    private int cageSizeY = 4;
    private int cageSizeZ = 3;
    private ElevatorCage cage = null;
    private final ArrayList<Integer> floors = new ArrayList();
    private final ArrayList<FloorData> floorData = new ArrayList();
    private boolean shouldBeSynced = false;
    private Map<Integer, Set<BlockPos>> comparatorListeners = new Int2ObjectArrayMap();
    private int syncCounter = 0;

    public ElevatorGroup(World world, int x, int z, EnumFacing facing) {
        this.world = world;
        this.x = x;
        this.z = z;
        this.facing = facing;
    }

    public void update() {
        if (!this.world.field_72995_K && this.shouldBeSynced) {
            this.shouldBeSynced = false;
            this.updateGroup();
        }
        if (this.isMoving) {
            if (this.currentY != (double)this.targetY) {
                this.lastY = this.currentY;
            }
            if (this.speed < this.targetSpeed) {
                this.speed = Math.min(this.targetSpeed, this.speed + 0.05);
            }
            if (this.currentY == (double)this.targetY) {
                this.stopElevator();
            } else if (Math.abs((double)this.targetY - this.currentY) < this.speed) {
                this.currentY = this.targetY;
                this.moveElevator(this.lastY, this.currentY);
            } else {
                if (this.syncCurrentY != 2.147483647E9) {
                    this.currentY = this.syncCurrentY;
                    this.syncCurrentY = 2.147483647E9;
                } else {
                    this.currentY += Math.signum((double)this.targetY - this.currentY) * this.speed;
                }
                this.moveElevator(this.lastY, this.currentY);
            }
            if (this.syncCounter >= 10) {
                this.syncMovement();
                this.syncCounter = 0;
            }
            ++this.syncCounter;
        }
    }

    private void moveElevator(double oldY, double newY) {
        ElevatorCollisionHandler.handleEntityCollisions(this.world, this.cage.bounds, this.cage.collisionBoxes, this.getCageAnchorPos(oldY), new Vec3d((double)this.x, newY - oldY, 0.0));
    }

    private void stopElevator() {
        this.isMoving = false;
        this.cage.place(this.world, this.getCageAnchorBlockPos(this.targetY));
        this.moveElevator(this.lastY, this.currentY);
        if (!this.world.field_72995_K) {
            this.world.func_175666_e(this.getPos(this.targetY), (Block)MovingElevators.elevator_block);
            for (BlockPos pos : this.comparatorListeners.getOrDefault(this.targetY, Collections.emptySet())) {
                if (!this.world.func_175667_e(pos)) continue;
                this.world.func_175666_e(pos, this.world.func_180495_p(pos).func_177230_c());
            }
            this.shouldBeSynced = true;
            Vec3d soundPos = this.getCageAnchorPos(this.targetY).func_72441_c((double)this.cageSizeX / 2.0, (double)this.cageSizeY / 2.0, (double)this.cageSizeZ / 2.0);
            this.world.func_184148_a(null, soundPos.field_72450_a, soundPos.field_72448_b, soundPos.field_72449_c, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.4f, 0.5f);
            this.syncCounter = 0;
        }
    }

    private void startElevator(int currentY, int targetY) {
        if (this.world == null || this.isMoving) {
            return;
        }
        ElevatorCage cage = ElevatorCage.createCageAndClear(this.world, this.getCageAnchorBlockPos(currentY), this.cageSizeX, this.cageSizeY, this.cageSizeZ);
        if (cage == null) {
            return;
        }
        this.cage = cage;
        this.isMoving = true;
        this.targetY = targetY;
        this.lastY = this.currentY = (double)currentY;
        this.speed = 0.0;
        if (!this.world.field_72995_K) {
            this.world.func_175666_e(this.getPos(currentY), (Block)MovingElevators.elevator_block);
            for (BlockPos pos : this.comparatorListeners.getOrDefault(currentY, Collections.emptySet())) {
                if (!this.world.func_175667_e(pos)) continue;
                this.world.func_175666_e(pos, this.world.func_180495_p(pos).func_177230_c());
            }
            this.updateGroup();
        }
    }

    public void onButtonPress(boolean isUp, boolean isDown, int yLevel) {
        if (this.isMoving || !this.floors.contains(yLevel)) {
            return;
        }
        ControllerBlockEntity tile = this.getTile(yLevel);
        if (tile == null) {
            return;
        }
        if (isUp) {
            if (this.isCageAvailableAt(tile)) {
                for (int floor = this.floors.indexOf(yLevel) + 1; floor < this.floors.size(); ++floor) {
                    ControllerBlockEntity tile2 = this.getTile(this.floors.get(floor));
                    if (tile2 == null) continue;
                    if (this.canCageBePlacedAt(tile2)) {
                        this.startElevator(yLevel, this.floors.get(floor));
                    }
                    return;
                }
            }
        } else if (isDown) {
            if (this.isCageAvailableAt(tile)) {
                for (int floor = this.floors.indexOf(yLevel) - 1; floor >= 0; --floor) {
                    ControllerBlockEntity tile2 = this.getTile(this.floors.get(floor));
                    if (tile2 == null) continue;
                    if (this.canCageBePlacedAt(tile2)) {
                        this.startElevator(yLevel, this.floors.get(floor));
                    }
                    return;
                }
            }
        } else if (this.canCageBePlacedAt(tile)) {
            this.floors.sort(Comparator.comparingInt(a -> Math.abs(a - yLevel)));
            for (int y : this.floors) {
                ControllerBlockEntity tile2;
                if (y == yLevel || (tile2 = this.getTile(y)) == null || !this.isCageAvailableAt(tile2)) continue;
                this.floors.sort(Integer::compare);
                this.startElevator(y, yLevel);
                return;
            }
            this.floors.sort(Integer::compare);
        }
    }

    public void onDisplayPress(int yLevel, int floorOffset) {
        if (this.isMoving || !this.floors.contains(yLevel)) {
            return;
        }
        int floor = this.floors.indexOf(yLevel);
        if (floorOffset == 0) {
            this.onButtonPress(false, false, yLevel);
            return;
        }
        int toFloor = floor + floorOffset;
        if (toFloor < 0 || toFloor >= this.floors.size()) {
            return;
        }
        ControllerBlockEntity tile = this.getTile(yLevel);
        int toY = this.floors.get(toFloor);
        ControllerBlockEntity toTile = this.getTile(toY);
        if (tile != null && toTile != null && this.isCageAvailableAt(tile) && this.canCageBePlacedAt(toTile)) {
            this.startElevator(yLevel, toY);
        }
    }

    public void remove(ControllerBlockEntity tile) {
        int floor = this.getFloorNumber(tile.func_174877_v().func_177956_o());
        this.floors.remove(floor);
        this.floorData.remove(floor);
        if (this.floors.isEmpty()) {
            if (this.isMoving) {
                Vec3d spawnPos = this.getCageAnchorPos(this.targetY).func_72441_c((double)this.cageSizeX / 2.0, (double)this.cageSizeY / 2.0, (double)this.cageSizeZ / 2.0);
                IBlockState[][][] iBlockStateArray = this.cage.blockStates;
                int n = iBlockStateArray.length;
                for (int i = 0; i < n; ++i) {
                    IBlockState[][] arr;
                    IBlockState[][] iBlockStateArray2 = arr = iBlockStateArray[i];
                    int n2 = iBlockStateArray2.length;
                    for (int j = 0; j < n2; ++j) {
                        IBlockState[] arr2;
                        for (IBlockState state : arr2 = iBlockStateArray2[j]) {
                            EntityItem entity = new EntityItem(this.world, spawnPos.field_72450_a, spawnPos.field_72448_b, spawnPos.field_72449_c, new ItemStack(state.func_177230_c()));
                            this.world.func_72838_d((Entity)entity);
                        }
                    }
                }
            }
        } else {
            this.shouldBeSynced = true;
        }
    }

    public void add(ControllerBlockEntity tile) {
        if (tile == null) {
            return;
        }
        int y = tile.func_174877_v().func_177956_o();
        if (this.floors.contains(y)) {
            return;
        }
        FloorData floorData = new FloorData(tile.getFloorName(), tile.getDisplayLabelColor());
        for (int i = 0; i < this.floors.size(); ++i) {
            if (y >= this.floors.get(i)) continue;
            this.floors.add(i, y);
            this.floorData.add(i, floorData);
            break;
        }
        if (!this.floors.contains(y)) {
            this.floors.add(y);
            this.floorData.add(floorData);
        }
        this.shouldBeSynced = true;
    }

    public void updateFloorData(ControllerBlockEntity tile, String name, EnumDyeColor color) {
        int floor = this.getFloorNumber(tile.func_174877_v().func_177956_o());
        if (floor == -1) {
            return;
        }
        FloorData data = this.floorData.get(floor);
        if (!Objects.equals(name, data.name) || color != data.color) {
            data.name = name;
            data.color = color;
            this.shouldBeSynced = true;
        }
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public double getLastY() {
        return this.lastY;
    }

    public double getCurrentY() {
        return this.currentY;
    }

    public void updateCurrentY(double y, double speed) {
        if (this.isMoving && (this.currentY < this.lastY ? y < this.currentY : y > this.currentY) && speed >= this.speed) {
            this.syncCurrentY = y;
            this.speed = speed;
        }
    }

    public ElevatorCage getCage() {
        return this.cage;
    }

    public double getTargetSpeed() {
        return this.targetSpeed;
    }

    public void setTargetSpeed(double targetSpeed) {
        this.targetSpeed = targetSpeed;
        this.shouldBeSynced = true;
    }

    public int getCageSideOffset() {
        return this.cageSideOffset;
    }

    public boolean canIncreaseCageSideOffset() {
        return !this.isMoving() && this.cageSideOffset < 2 + (this.facing == EnumFacing.NORTH || this.facing == EnumFacing.WEST ? (this.getCageWidth() - 1) / 2 : (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f));
    }

    public void increaseCageSideOffset() {
        if (this.canIncreaseCageSideOffset()) {
            ++this.cageSideOffset;
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageSideOffset() {
        return !this.isMoving() && this.cageSideOffset > -2 - (this.facing == EnumFacing.NORTH || this.facing == EnumFacing.WEST ? (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f) : (this.getCageWidth() - 1) / 2);
    }

    public void decreaseCageSideOffset() {
        if (this.canDecreaseCageSideOffset()) {
            --this.cageSideOffset;
            this.shouldBeSynced = true;
        }
    }

    public int getCageDepthOffset() {
        return this.cageDepthOffset;
    }

    public boolean canIncreaseCageDepthOffset() {
        return !this.isMoving() && this.cageDepthOffset < 2;
    }

    public void increaseCageDepthOffset() {
        if (this.canIncreaseCageDepthOffset()) {
            ++this.cageDepthOffset;
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageDepthOffset() {
        return !this.isMoving() && this.cageDepthOffset > 0;
    }

    public void decreaseCageDepthOffset() {
        if (this.canDecreaseCageDepthOffset()) {
            --this.cageDepthOffset;
            this.shouldBeSynced = true;
        }
    }

    public int getCageHeightOffset() {
        return this.cageHeightOffset;
    }

    public boolean canIncreaseCageHeightOffset() {
        return !this.isMoving() && this.cageHeightOffset < 3;
    }

    public void increaseCageHeightOffset() {
        if (this.canIncreaseCageHeightOffset()) {
            ++this.cageHeightOffset;
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageHeightOffset() {
        return !this.isMoving() && this.cageHeightOffset > -this.cageSizeY;
    }

    public void decreaseCageHeightOffset() {
        if (this.canDecreaseCageHeightOffset()) {
            --this.cageHeightOffset;
            this.shouldBeSynced = true;
        }
    }

    public int getCageWidth() {
        return this.facing.func_176740_k() == EnumFacing.Axis.X ? this.cageSizeZ : this.cageSizeX;
    }

    public boolean canIncreaseCageWidth() {
        return !this.isMoving && this.getCageWidth() < MovingElevatorsConfig.maxCabinHorizontalSize.get();
    }

    public void increaseCageWidth() {
        if (!this.isMoving && this.canIncreaseCageWidth()) {
            if (this.facing.func_176740_k() == EnumFacing.Axis.X) {
                ++this.cageSizeZ;
            } else {
                ++this.cageSizeX;
            }
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageWidth() {
        return !this.isMoving && this.getCageWidth() > 1;
    }

    public void decreaseCageWidth() {
        if (!this.isMoving && this.canDecreaseCageWidth()) {
            if (this.facing.func_176740_k() == EnumFacing.Axis.X) {
                --this.cageSizeZ;
            } else {
                --this.cageSizeX;
            }
            if (this.cageSideOffset > 2 + (this.facing == EnumFacing.NORTH || this.facing == EnumFacing.WEST ? (this.getCageWidth() - 1) / 2 : (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f))) {
                this.cageSideOffset = 2 + (this.facing == EnumFacing.NORTH || this.facing == EnumFacing.WEST ? (this.getCageWidth() - 1) / 2 : (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f));
            } else if (this.cageSideOffset < -2 - (this.facing == EnumFacing.NORTH || this.facing == EnumFacing.WEST ? (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f) : (this.getCageWidth() - 1) / 2)) {
                this.cageSideOffset = -2 - (this.facing == EnumFacing.NORTH || this.facing == EnumFacing.WEST ? (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f) : (this.getCageWidth() - 1) / 2);
            }
            this.shouldBeSynced = true;
        }
    }

    public int getCageDepth() {
        return this.facing.func_176740_k() == EnumFacing.Axis.X ? this.cageSizeX : this.cageSizeZ;
    }

    public boolean canIncreaseCageDepth() {
        return !this.isMoving && this.getCageDepth() < MovingElevatorsConfig.maxCabinHorizontalSize.get();
    }

    public void increaseCageDepth() {
        if (!this.isMoving && this.canIncreaseCageDepth()) {
            if (this.facing.func_176740_k() == EnumFacing.Axis.X) {
                ++this.cageSizeX;
            } else {
                ++this.cageSizeZ;
            }
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageDepth() {
        return !this.isMoving && this.getCageDepth() > 1;
    }

    public void decreaseCageDepth() {
        if (!this.isMoving && this.canDecreaseCageDepth()) {
            if (this.facing.func_176740_k() == EnumFacing.Axis.X) {
                --this.cageSizeX;
            } else {
                --this.cageSizeZ;
            }
            this.shouldBeSynced = true;
        }
    }

    public int getCageHeight() {
        return this.getCageSizeY();
    }

    public boolean canIncreaseCageHeight() {
        return !this.isMoving && this.cageSizeY < MovingElevatorsConfig.maxCabinVerticalSize.get();
    }

    public void increaseCageHeight() {
        if (!this.isMoving && this.canIncreaseCageHeight()) {
            ++this.cageSizeY;
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageHeight() {
        return !this.isMoving && this.cageSizeY > 1;
    }

    public void decreaseCageHeight() {
        if (!this.isMoving && this.canDecreaseCageHeight()) {
            --this.cageSizeY;
            if (this.cageHeightOffset < -this.cageSizeY) {
                this.cageHeightOffset = -this.cageSizeY;
            }
            this.shouldBeSynced = true;
        }
    }

    public int getCageSizeX() {
        return this.cageSizeX;
    }

    public int getCageSizeY() {
        return this.cageSizeY;
    }

    public int getCageSizeZ() {
        return this.cageSizeZ;
    }

    public EnumDyeColor getFloorDisplayColor(int floor) {
        return this.floorData.get((int)floor).color;
    }

    public String getFloorDisplayName(int floor) {
        return this.floorData.get((int)floor).name;
    }

    public BlockPos getCageAnchorBlockPos(int y) {
        int x = 0;
        int z = 0;
        if (this.facing == EnumFacing.NORTH) {
            x = this.x - this.cageSizeX / 2 - this.cageSideOffset;
            z = this.z - this.cageSizeZ - this.cageDepthOffset;
        } else if (this.facing == EnumFacing.SOUTH) {
            x = this.x - this.cageSizeX / 2 + this.cageSideOffset;
            z = this.z + 1 + this.cageDepthOffset;
        } else if (this.facing == EnumFacing.WEST) {
            x = this.x - this.cageSizeX - this.cageDepthOffset;
            z = this.z - this.cageSizeZ / 2 + this.cageSideOffset;
        } else if (this.facing == EnumFacing.EAST) {
            x = this.x + 1 + this.cageDepthOffset;
            z = this.z - this.cageSizeZ / 2 - this.cageSideOffset;
        }
        return new BlockPos(x, y += this.cageHeightOffset, z);
    }

    public Vec3d getCageAnchorPos(double y) {
        BlockPos pos = this.getCageAnchorBlockPos(0);
        return new Vec3d((double)pos.func_177958_n(), y + (double)this.cageHeightOffset, (double)pos.func_177952_p());
    }

    public boolean isCageAvailableAt(ControllerBlockEntity tile) {
        return ElevatorCage.canCreateCage(this.world, this.getCageAnchorBlockPos(tile.func_174877_v().func_177956_o()), this.cageSizeX, this.cageSizeY, this.cageSizeZ);
    }

    public boolean canCageBePlacedAt(ControllerBlockEntity tile) {
        BlockPos startPos = this.getCageAnchorBlockPos(tile.func_174877_v().func_177956_o());
        for (int x = 0; x < this.cageSizeX; ++x) {
            for (int y = 0; y < this.cageSizeY; ++y) {
                for (int z = 0; z < this.cageSizeZ; ++z) {
                    if (this.world.func_175623_d(startPos.func_177982_a(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void addComparatorListener(int floorYLevel, BlockPos blockPos) {
        this.comparatorListeners.putIfAbsent(floorYLevel, new HashSet());
        this.comparatorListeners.get(floorYLevel).add(blockPos);
    }

    public boolean removeComparatorListener(BlockPos blockPos) {
        boolean removed = false;
        for (Set<BlockPos> positions : this.comparatorListeners.values()) {
            if (!positions.remove(blockPos)) continue;
            removed = true;
        }
        return removed;
    }

    public NBTTagCompound write() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("isMoving", this.isMoving);
        if (this.isMoving) {
            compound.func_74768_a("targetY", this.targetY);
            compound.func_74780_a("lastY", this.lastY);
            compound.func_74780_a("currentY", this.currentY);
            compound.func_74782_a("cage", (NBTBase)this.cage.write());
        }
        compound.func_74780_a("targetSpeed", this.targetSpeed);
        compound.func_74780_a("speed", this.speed);
        compound.func_74768_a("cageSideOffset", this.cageSideOffset);
        compound.func_74768_a("cageDepthOffset", this.cageDepthOffset);
        compound.func_74768_a("cageHeightOffset", this.cageHeightOffset);
        compound.func_74768_a("cageSizeX", this.cageSizeX);
        compound.func_74768_a("cageSizeY", this.cageSizeY);
        compound.func_74768_a("cageSizeZ", this.cageSizeZ);
        int[] arr = new int[this.floors.size()];
        for (int i = 0; i < this.floors.size(); ++i) {
            arr[i] = this.floors.get(i);
        }
        compound.func_74783_a("floors", arr);
        NBTTagList floorDataTag = new NBTTagList();
        for (FloorData floorDatum : this.floorData) {
            floorDataTag.func_74742_a((NBTBase)floorDatum.write());
        }
        compound.func_74782_a("floorData", (NBTBase)floorDataTag);
        return compound;
    }

    public void read(NBTTagCompound compound) {
        NBTBase base;
        if (compound.func_74764_b("moving")) {
            this.isMoving = compound.func_74767_n("moving");
            int size = compound.func_74762_e("size");
            if (this.isMoving) {
                this.targetY = compound.func_74762_e("targetY");
                this.lastY = compound.func_74769_h("lastY");
                this.currentY = compound.func_74769_h("currentY");
                IBlockState[][][] blockStates = new IBlockState[size][1][size];
                BlockShape shape = BlockShape.empty();
                for (int x = 0; x < size; ++x) {
                    for (int z = 0; z < size; ++z) {
                        IBlockState state = Block.func_176220_d((int)compound.func_74762_e("platform" + x + "," + z));
                        if (state.func_177230_c() == Blocks.field_150350_a) continue;
                        blockStates[x][0][z] = state;
                        shape = BlockShape.or((BlockShape)shape, (BlockShape[])new BlockShape[]{BlockShape.create((AxisAlignedBB)state.func_185890_d((IBlockAccess)this.world, this.getPos((int)this.currentY)))});
                    }
                }
                this.cage = new ElevatorCage(size, 1, size, blockStates, shape.toBoxes());
            }
            this.speed = this.targetSpeed = compound.func_74769_h("speed");
            this.cageSizeX = this.cageSizeZ = size;
            this.cageSizeY = 1;
        } else {
            this.isMoving = compound.func_74767_n("isMoving");
            if (this.isMoving) {
                this.targetY = compound.func_74762_e("targetY");
                this.lastY = compound.func_74769_h("lastY");
                this.currentY = compound.func_74769_h("currentY");
                this.cage = ElevatorCage.read(compound.func_74775_l("cage"));
            }
            this.targetSpeed = compound.func_74769_h("targetSpeed");
            this.speed = compound.func_74769_h("speed");
            this.cageSideOffset = compound.func_74762_e("cageSideOffset");
            this.cageDepthOffset = compound.func_74762_e("cageDepthOffset");
            this.cageHeightOffset = compound.func_74762_e("cageHeightOffset");
            this.cageSizeX = compound.func_74762_e("cageSizeX");
            this.cageSizeY = compound.func_74762_e("cageSizeY");
            this.cageSizeZ = compound.func_74762_e("cageSizeZ");
        }
        this.floors.clear();
        for (int y : compound.func_74759_k("floors")) {
            this.floors.add(y);
        }
        this.floorData.clear();
        if (compound.func_150297_b("floorData", 9) && (base = compound.func_74781_a("floorData")) instanceof NBTTagList) {
            NBTTagList floorDataTag = (NBTTagList)base;
            for (NBTBase tag : floorDataTag) {
                this.floorData.add(FloorData.read((NBTTagCompound)tag));
            }
        }
    }

    private BlockPos getPos(int y) {
        return new BlockPos(this.x, y, this.z);
    }

    private ControllerBlockEntity getTile(int y) {
        if (this.world == null) {
            return null;
        }
        TileEntity tile = this.world.func_175625_s(this.getPos(y));
        return tile instanceof ControllerBlockEntity ? (ControllerBlockEntity)tile : null;
    }

    public int getFloorCount() {
        return this.floors.size();
    }

    public int getFloorNumber(int y) {
        return this.floors.indexOf(y);
    }

    public int getFloorYLevel(int floor) {
        return this.floors.get(floor);
    }

    public ControllerBlockEntity getTileForFloor(int floor) {
        if (floor < 0 || floor >= this.floors.size()) {
            return null;
        }
        return this.getTile(this.floors.get(floor));
    }

    private void updateGroup() {
        ElevatorGroupCapability groups = (ElevatorGroupCapability)this.world.getCapability(ElevatorGroupCapability.CAPABILITY, null);
        groups.updateGroup(this);
    }

    private void syncMovement() {
        if (!this.world.field_72995_K) {
            MovingElevators.CHANNEL.sendToDimension(this.world, (BasePacket)new PacketSyncElevatorMovement(this.x, this.z, this.facing, this.currentY, this.speed));
        }
    }

    private static class FloorData {
        public String name;
        public EnumDyeColor color;

        public FloorData(String name, EnumDyeColor color) {
            this.name = name;
            this.color = color;
        }

        public NBTTagCompound write() {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.name != null) {
                tag.func_74778_a("name", this.name);
            }
            tag.func_74768_a("color", this.color.func_176767_b());
            return tag;
        }

        public static FloorData read(NBTTagCompound tag) {
            return new FloorData(tag.func_74764_b("name") ? tag.func_74779_i("name") : null, EnumDyeColor.func_176766_a((int)tag.func_74762_e("color")));
        }
    }
}

