/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui;

import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.gui.preview.ElevatorPreviewRenderer;
import com.supermartijn642.movingelevators.gui.preview.WorldBlockCapture;
import java.util.function.Supplier;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class ElevatorPreviewWidget
extends Widget {
    private final Supplier<ControllerBlockEntity> elevatorEntity;
    private final Supplier<BlockPos> previewSizeIncrease;
    private final Supplier<BlockPos> previewOffset;
    private float yaw = 20.0f;
    private float pitch = 30.0f;
    private boolean dragging = false;
    private int mouseStartX;
    private int mouseStartY;

    public ElevatorPreviewWidget(int x, int y, int width, int height, Supplier<ControllerBlockEntity> elevatorEntity, Supplier<BlockPos> previewSizeIncrease, Supplier<BlockPos> previewOffset) {
        super(x, y, width, height);
        this.elevatorEntity = elevatorEntity;
        this.previewSizeIncrease = previewSizeIncrease;
        this.previewOffset = previewOffset;
    }

    protected ITextComponent getNarrationMessage() {
        return null;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.dragging) {
            this.yaw = (float)((double)this.yaw + (double)(mouseX - this.mouseStartX) / 100.0 * 360.0);
            this.pitch = (float)((double)this.pitch + (double)(mouseY - this.mouseStartY) / 100.0 * 360.0);
            this.mouseStartX = mouseX;
            this.mouseStartY = mouseY;
        }
        ControllerBlockEntity elevatorEntity = this.elevatorEntity.get();
        ElevatorGroup group = elevatorEntity.getGroup();
        BlockPos anchorPos = group.getCageAnchorBlockPos(elevatorEntity.func_174877_v().func_177956_o());
        WorldBlockCapture capture = new WorldBlockCapture(group.world);
        capture.putBlock(elevatorEntity.func_174877_v(), elevatorEntity.func_174877_v());
        for (int x = 0; x < group.getCageSizeX(); ++x) {
            for (int y = 0; y < group.getCageSizeY(); ++y) {
                for (int z = 0; z < group.getCageSizeZ(); ++z) {
                    BlockPos pos = anchorPos.func_177982_a(x, y, z);
                    capture.putBlock(pos, pos);
                }
            }
        }
        AxisAlignedBB cabinBox = new AxisAlignedBB(anchorPos, anchorPos.func_177982_a(group.getCageSizeX(), group.getCageSizeY(), group.getCageSizeZ())).func_186662_g(0.1);
        BlockPos previewSizeIncrease = this.previewSizeIncrease.get();
        BlockPos previewOffset = this.previewOffset.get();
        AxisAlignedBB previewBox = null;
        if (!previewSizeIncrease.equals((Object)BlockPos.field_177992_a) || !previewOffset.equals((Object)BlockPos.field_177992_a)) {
            int cabinWidth = group.getCageWidth() + previewSizeIncrease.func_177958_n();
            int cabinDepth = group.getCageDepth() + previewSizeIncrease.func_177952_p();
            int cabinHeight = group.getCageHeight() + previewSizeIncrease.func_177956_o();
            int sideOffset = group.getCageSideOffset() + previewOffset.func_177958_n();
            int depthOffset = group.getCageDepthOffset() + previewOffset.func_177952_p();
            int heightOffset = group.getCageHeightOffset() + previewOffset.func_177956_o();
            if (sideOffset > 2 + (group.facing == EnumFacing.NORTH || group.facing == EnumFacing.WEST ? (cabinWidth - 1) / 2 : (int)Math.ceil((float)(cabinWidth - 1) / 2.0f))) {
                sideOffset = 2 + (group.facing == EnumFacing.NORTH || group.facing == EnumFacing.WEST ? (cabinWidth - 1) / 2 : (int)Math.ceil((float)(cabinWidth - 1) / 2.0f));
            } else if (sideOffset < -2 - (group.facing == EnumFacing.NORTH || group.facing == EnumFacing.WEST ? (int)Math.ceil((float)(cabinWidth - 1) / 2.0f) : (cabinWidth - 1) / 2)) {
                sideOffset = -2 - (group.facing == EnumFacing.NORTH || group.facing == EnumFacing.WEST ? (int)Math.ceil((float)(cabinWidth - 1) / 2.0f) : (cabinWidth - 1) / 2);
            }
            if (heightOffset < -cabinHeight) {
                heightOffset = -cabinHeight;
            }
            int anchorX = 0;
            int anchorY = elevatorEntity.func_174877_v().func_177956_o();
            int anchorZ = 0;
            if (group.facing == EnumFacing.NORTH) {
                anchorX = group.x - cabinWidth / 2 - sideOffset;
                anchorZ = group.z - cabinDepth - depthOffset;
            } else if (group.facing == EnumFacing.SOUTH) {
                anchorX = group.x - cabinWidth / 2 + sideOffset;
                anchorZ = group.z + 1 + depthOffset;
            } else if (group.facing == EnumFacing.WEST) {
                anchorX = group.x - cabinDepth - depthOffset;
                anchorZ = group.z - cabinWidth / 2 + sideOffset;
            } else if (group.facing == EnumFacing.EAST) {
                anchorX = group.x + 1 + depthOffset;
                anchorZ = group.z - cabinWidth / 2 - sideOffset;
            }
            previewBox = new AxisAlignedBB((double)anchorX, (double)(anchorY += heightOffset), (double)anchorZ, (double)(anchorX + (group.facing.func_176740_k() == EnumFacing.Axis.X ? cabinDepth : cabinWidth)), (double)(anchorY + cabinHeight), (double)(anchorZ + (group.facing.func_176740_k() == EnumFacing.Axis.Z ? cabinDepth : cabinWidth))).func_186662_g(0.1);
        }
        ElevatorPreviewRenderer.renderPreview(capture, cabinBox, previewBox, (float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, Math.min(this.width, this.height), this.yaw + group.facing.func_185119_l(), this.pitch, false);
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
        if (mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height) {
            this.dragging = true;
            this.mouseStartX = mouseX;
            this.mouseStartY = mouseY;
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int button) {
        this.dragging = false;
    }
}

