/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.BlockSecurityCamera;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.geforcemods.securitycraft.network.server.GiveNightVision;
import net.geforcemods.securitycraft.network.server.SetCameraPowered;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntitySecurityCamera
extends Entity {
    protected final float cameraSpeed = ConfigHandler.cameraSpeed;
    public int screenshotSoundCooldown = 0;
    protected int redstoneCooldown = 0;
    protected int toggleNightVisionCooldown = 0;
    protected boolean shouldProvideNightVision = false;
    protected float zoomAmount = 1.0f;
    protected boolean zooming = false;
    private ForgeChunkManager.Ticket chunkTicket;

    public EntitySecurityCamera(World world) {
        super(world);
        this.field_70145_X = true;
        this.field_98038_p = true;
        this.field_70131_O = 1.0E-4f;
        this.field_70130_N = 1.0E-4f;
    }

    public EntitySecurityCamera(World world, double x, double y, double z) {
        this(world);
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (!(te instanceof TileEntitySecurityCamera)) {
            this.func_70106_y();
            return;
        }
        TileEntitySecurityCamera cam = (TileEntitySecurityCamera)te;
        x += 0.5;
        y += 0.5;
        z += 0.5;
        if (cam.down) {
            y += 0.25;
        }
        this.func_70107_b(x, y, z);
        this.setInitialPitchYaw(cam);
    }

    public EntitySecurityCamera(World world, double x, double y, double z, EntitySecurityCamera oldCamera) {
        this(world, x, y, z);
        oldCamera.discardCamera();
    }

    private void setInitialPitchYaw(TileEntitySecurityCamera te) {
        this.field_70125_A = 30.0f;
        EnumFacing facing = (EnumFacing)this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_177229_b((IProperty)BlockSecurityCamera.FACING);
        if (facing == EnumFacing.NORTH) {
            this.field_70177_z = 180.0f;
        } else if (facing == EnumFacing.WEST) {
            this.field_70177_z = 90.0f;
        } else if (facing == EnumFacing.SOUTH) {
            this.field_70177_z = 0.0f;
        } else if (facing == EnumFacing.EAST) {
            this.field_70177_z = 270.0f;
        } else if (facing == EnumFacing.DOWN) {
            this.field_70125_A = 75.0f;
        }
    }

    protected boolean func_142008_O() {
        return false;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            if (this.screenshotSoundCooldown > 0) {
                --this.screenshotSoundCooldown;
            }
            if (this.redstoneCooldown > 0) {
                --this.redstoneCooldown;
            }
            if (this.toggleNightVisionCooldown > 0) {
                --this.toggleNightVisionCooldown;
            }
            if (this.shouldProvideNightVision) {
                SecurityCraft.network.sendToServer((IMessage)new GiveNightVision());
            }
        } else if (this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_177230_c() != SCContent.securityCamera) {
            this.func_70106_y();
        }
    }

    public void toggleRedstonePower() {
        BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (((IModuleInventory)this.field_70170_p.func_175625_s(pos)).hasModule(EnumModuleType.REDSTONE)) {
            SecurityCraft.network.sendToServer((IMessage)new SetCameraPowered(pos, (Boolean)this.field_70170_p.func_180495_p(pos).func_177229_b((IProperty)BlockSecurityCamera.POWERED) == false));
        }
    }

    public void toggleNightVision() {
        this.toggleNightVisionCooldown = 30;
        this.shouldProvideNightVision = !this.shouldProvideNightVision;
    }

    public float getZoomAmount() {
        return this.zoomAmount;
    }

    public boolean isCameraDown() {
        BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        return this.field_70170_p.func_175625_s(pos) instanceof TileEntitySecurityCamera && ((TileEntitySecurityCamera)this.field_70170_p.func_175625_s((BlockPos)pos)).down;
    }

    protected void func_70101_b(float yaw, float pitch) {
        super.func_70101_b(yaw, pitch);
    }

    public void stopViewing(EntityPlayerMP player) {
        if (!this.field_70170_p.field_72995_K) {
            WorldServer serverWorld = (WorldServer)this.field_70170_p;
            BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Chunk chunk = serverWorld.func_175726_f(pos);
            ChunkPos chunkPos = chunk.func_76632_l();
            int viewDistance = player.field_71133_b.func_184103_al().func_72395_o();
            this.discardCamera();
            for (int cx = chunkPos.field_77276_a - viewDistance; cx <= chunkPos.field_77276_a + viewDistance; ++cx) {
                for (int cz = chunkPos.field_77275_b - viewDistance; cz <= chunkPos.field_77275_b + viewDistance; ++cz) {
                    serverWorld.func_184164_w().func_187302_c(cx, cz).func_187277_b(player);
                }
            }
            serverWorld.func_184164_w().func_72683_a(player);
            player.field_175401_bS = player;
            SecurityCraft.network.sendTo((IMessage)new SetCameraView((Entity)player), player);
            for (EntityTrackerEntry entry : serverWorld.func_73039_n().field_72793_b) {
                if (entry.func_187260_b() == player) continue;
                entry.func_73117_b(player);
            }
        }
    }

    public void discardCamera() {
        if (!this.field_70170_p.field_72995_K) {
            TileEntity te = this.field_70170_p.func_175625_s(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v));
            if (te instanceof TileEntitySecurityCamera) {
                ((TileEntitySecurityCamera)te).stopViewing();
            }
            if (this.chunkTicket != null) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
                this.chunkTicket = null;
            }
        }
        this.func_70106_y();
    }

    public void setChunkTicket(ForgeChunkManager.Ticket chunkTicket) {
        this.chunkTicket = chunkTicket;
    }

    protected void func_70088_a() {
    }

    public void func_70014_b(NBTTagCompound tag) {
    }

    public void func_70037_a(NBTTagCompound tag) {
    }
}

