/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import java.io.IOException;
import java.util.Arrays;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.ContainerBlockPocketManager;
import net.geforcemods.securitycraft.gui.components.GuiSlider;
import net.geforcemods.securitycraft.gui.components.StackHoverChecker;
import net.geforcemods.securitycraft.gui.components.StringHoverChecker;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.network.server.SyncBlockPocketManager;
import net.geforcemods.securitycraft.tileentity.TileEntityBlockPocketManager;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;

public class GuiBlockPocketManager
extends GuiContainer
implements GuiSlider.ISlider {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/block_pocket_manager.png");
    private static final ResourceLocation TEXTURE_STORAGE = new ResourceLocation("securitycraft:textures/gui/container/block_pocket_manager_storage.png");
    private static final ItemStack BLOCK_POCKET_WALL = new ItemStack(SCContent.blockPocketWall);
    private static final ItemStack REINFORCED_CHISELED_CRYSTAL_QUARTZ = new ItemStack(SCContent.reinforcedCrystalQuartz, 1, 1);
    private static final ItemStack REINFORCED_CRYSTAL_QUARTZ_PILLAR = new ItemStack(SCContent.reinforcedCrystalQuartz, 1, 2);
    private final String blockPocketManager = Utils.localize(SCContent.blockPocketManager.func_149739_a() + ".name", new Object[0]).func_150254_d();
    private final String youNeed = Utils.localize("gui.securitycraft:blockPocketManager.youNeed", new Object[0]).func_150254_d();
    private final boolean storage;
    private final boolean isOwner;
    private final int[] materialCounts = new int[3];
    private final InventoryPlayer playerInventory;
    public TileEntityBlockPocketManager te;
    private int size = 5;
    private GuiButton toggleButton;
    private GuiButton sizeButton;
    private GuiButton assembleButton;
    private GuiButton outlineButton;
    private GuiSlider offsetSlider;
    private StackHoverChecker[] hoverCheckers = new StackHoverChecker[3];
    private StringHoverChecker assembleHoverChecker;
    private int wallsNeededOverall = (this.size - 2) * (this.size - 2) * 6;
    private int pillarsNeededOverall = (this.size - 2) * 12 - 1;
    private final int chiseledNeededOverall = 8;
    private int wallsStillNeeded;
    private int pillarsStillNeeded;
    private int chiseledStillNeeded;

    public GuiBlockPocketManager(InventoryPlayer inventory, TileEntityBlockPocketManager te) {
        super((Container)new ContainerBlockPocketManager(inventory, te));
        this.te = te;
        this.playerInventory = inventory;
        this.size = te.size;
        this.isOwner = te.getOwner().isOwner(inventory.field_70458_d);
        boolean bl = this.storage = te != null && te.hasModule(EnumModuleType.STORAGE) && this.isOwner;
        if (this.storage) {
            this.field_146999_f = 256;
        }
        this.field_147000_g = !this.storage ? 194 : 240;
    }

    public void func_73866_w_() {
        int[] nArray;
        super.func_73866_w_();
        int width = this.storage ? 123 : this.field_146999_f;
        int widgetWidth = this.storage ? 110 : 120;
        int widgetOffset = widgetWidth / 2;
        if (this.storage) {
            int[] nArray2 = new int[5];
            nArray2[0] = -76;
            nArray2[1] = -100;
            nArray2[2] = -52;
            nArray2[3] = -28;
            nArray = nArray2;
            nArray2[4] = -4;
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = -40;
            nArray3[1] = -70;
            nArray3[2] = 23;
            nArray3[3] = 47;
            nArray = nArray3;
            nArray3[4] = 71;
        }
        int[] yOffset = nArray;
        this.toggleButton = new GuiButton(0, this.field_147003_i + width / 2 - widgetOffset, this.field_147009_r + this.field_147000_g / 2 + yOffset[0], widgetWidth, 20, Utils.localize("gui.securitycraft:blockPocketManager." + (!this.te.enabled ? "activate" : "deactivate"), new Object[0]).func_150254_d());
        this.field_146292_n.add(this.toggleButton);
        this.sizeButton = new GuiButton(1, this.field_147003_i + width / 2 - widgetOffset, this.field_147009_r + this.field_147000_g / 2 + yOffset[1], widgetWidth, 20, Utils.localize("gui.securitycraft:blockPocketManager.size", this.size, this.size, this.size).func_150254_d());
        this.field_146292_n.add(this.sizeButton);
        this.assembleButton = new GuiButton(2, this.field_147003_i + width / 2 - widgetOffset, this.field_147009_r + this.field_147000_g / 2 + yOffset[2], widgetWidth, 20, Utils.localize("gui.securitycraft:blockPocketManager.assemble", new Object[0]).func_150254_d());
        this.field_146292_n.add(this.assembleButton);
        this.outlineButton = new GuiButton(3, this.field_147003_i + width / 2 - widgetOffset, this.field_147009_r + this.field_147000_g / 2 + yOffset[3], widgetWidth, 20, Utils.localize("gui.securitycraft:blockPocketManager.outline." + (!this.te.showOutline ? "show" : "hide"), new Object[0]).func_150254_d());
        this.field_146292_n.add(this.outlineButton);
        this.offsetSlider = new GuiSlider(Utils.localize("gui.securitycraft:projector.offset", this.te.autoBuildOffset).func_150254_d(), "", 4, this.field_147003_i + width / 2 - widgetOffset, this.field_147009_r + this.field_147000_g / 2 + yOffset[4], widgetWidth, 20, Utils.localize("gui.securitycraft:projector.offset", "").func_150254_d(), (-this.size + 2) / 2, (this.size - 2) / 2, this.te.autoBuildOffset, false, true, (GuiSlider.ISlider)this);
        this.field_146292_n.add(this.offsetSlider);
        this.offsetSlider.updateSlider();
        if (!this.te.getOwner().isOwner((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            this.offsetSlider.field_146124_l = false;
            this.outlineButton.field_146124_l = false;
            this.assembleButton.field_146124_l = false;
            this.toggleButton.field_146124_l = false;
            this.sizeButton.field_146124_l = false;
        } else {
            this.updateMaterialInformation(true);
            this.offsetSlider.field_146124_l = !this.te.enabled;
            this.sizeButton.field_146124_l = this.offsetSlider.field_146124_l;
        }
        if (!this.storage) {
            this.hoverCheckers[0] = new StackHoverChecker(BLOCK_POCKET_WALL, this.field_147009_r + 93, this.field_147009_r + 113, this.field_147003_i + 23, this.field_147003_i + 43);
            this.hoverCheckers[1] = new StackHoverChecker(REINFORCED_CRYSTAL_QUARTZ_PILLAR, this.field_147009_r + 93, this.field_147009_r + 113, this.field_147003_i + 75, this.field_147003_i + 95);
            this.hoverCheckers[2] = new StackHoverChecker(REINFORCED_CHISELED_CRYSTAL_QUARTZ, this.field_147009_r + 93, this.field_147009_r + 113, this.field_147003_i + 128, this.field_147003_i + 148);
        } else {
            this.hoverCheckers[0] = new StackHoverChecker(BLOCK_POCKET_WALL, this.field_147009_r + this.field_147000_g - 73, this.field_147009_r + this.field_147000_g - 54, this.field_147003_i + 174, this.field_147003_i + 191);
            this.hoverCheckers[1] = new StackHoverChecker(REINFORCED_CRYSTAL_QUARTZ_PILLAR, this.field_147009_r + this.field_147000_g - 50, this.field_147009_r + this.field_147000_g - 31, this.field_147003_i + 174, this.field_147003_i + 191);
            this.hoverCheckers[2] = new StackHoverChecker(REINFORCED_CHISELED_CRYSTAL_QUARTZ, this.field_147009_r + this.field_147000_g - 27, this.field_147009_r + this.field_147000_g - 9, this.field_147003_i + 174, this.field_147003_i + 191);
        }
        this.assembleHoverChecker = new StringHoverChecker(this.assembleButton, Arrays.asList(Utils.localize("gui.securitycraft:blockPocketManager.needStorageModule", new Object[0]).func_150254_d(), Utils.localize("messages.securitycraft:blockpocket.notEnoughItems", new Object[0]).func_150254_d()));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.blockPocketManager, (this.storage ? 123 : this.field_146999_f) / 2 - this.field_146289_q.func_78256_a(this.blockPocketManager) / 2, 6, 0x404040);
        if (!this.te.enabled && this.isOwner) {
            if (!this.storage) {
                this.field_146289_q.func_78276_b(this.youNeed, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.youNeed) / 2, 83, 0x404040);
                this.field_146289_q.func_78276_b(this.wallsNeededOverall + "", 42, 100, 0x404040);
                net.geforcemods.securitycraft.util.GuiUtils.drawItemStackToGui(BLOCK_POCKET_WALL, 25, 96, false);
                this.field_146289_q.func_78276_b(this.pillarsNeededOverall + "", 94, 100, 0x404040);
                net.geforcemods.securitycraft.util.GuiUtils.drawItemStackToGui(REINFORCED_CRYSTAL_QUARTZ_PILLAR, 77, 96, false);
                this.field_146289_q.func_78276_b("8", 147, 100, 0x404040);
                net.geforcemods.securitycraft.util.GuiUtils.drawItemStackToGui(REINFORCED_CHISELED_CRYSTAL_QUARTZ, 130, 96, false);
            } else {
                this.field_146289_q.func_78276_b(this.youNeed, 212 - this.field_146289_q.func_78256_a(this.youNeed) / 2, this.field_147000_g - 83, 0x404040);
                this.field_146289_q.func_78276_b(Math.max(0, this.wallsStillNeeded) + "", 192, this.field_147000_g - 66, 0x404040);
                net.geforcemods.securitycraft.util.GuiUtils.drawItemStackToGui(BLOCK_POCKET_WALL, 175, this.field_147000_g - 70, false);
                this.field_146289_q.func_78276_b(Math.max(0, this.pillarsStillNeeded) + "", 192, this.field_147000_g - 44, 0x404040);
                net.geforcemods.securitycraft.util.GuiUtils.drawItemStackToGui(REINFORCED_CRYSTAL_QUARTZ_PILLAR, 175, this.field_147000_g - 48, false);
                this.field_146289_q.func_78276_b(Math.max(0, this.chiseledStillNeeded) + "", 192, this.field_147000_g - 22, 0x404040);
                net.geforcemods.securitycraft.util.GuiUtils.drawItemStackToGui(REINFORCED_CHISELED_CRYSTAL_QUARTZ, 175, this.field_147000_g - 26, false);
            }
        }
        if (this.storage) {
            this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150254_d(), 8, this.field_147000_g - 94, 0x404040);
            this.func_191948_b(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (!this.te.enabled && this.isOwner) {
            for (StackHoverChecker shc : this.hoverCheckers) {
                if (!shc.checkHover(mouseX, mouseY)) continue;
                this.func_146285_a(shc.getStack(), mouseX, mouseY);
                return;
            }
        }
        if (!this.te.enabled && this.isOwner && !this.assembleButton.field_146124_l && this.assembleHoverChecker.checkHover(mouseX, mouseY)) {
            if (!this.storage) {
                GuiUtils.drawHoveringText(this.assembleHoverChecker.getLines().subList(0, 1), (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1, (FontRenderer)this.field_146289_q);
            } else {
                GuiUtils.drawHoveringText(this.assembleHoverChecker.getLines().subList(1, 2), (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1, (FontRenderer)this.field_146289_q);
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.storage ? TEXTURE_STORAGE : TEXTURE);
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_184098_a(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.func_184098_a(slot, slotId, mouseButton, type);
        this.updateMaterialInformation(true);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == this.toggleButton.field_146127_k) {
            if (this.te.enabled) {
                this.te.disableMultiblock();
            } else {
                this.te.size = this.size;
                TextComponentTranslation feedback = this.te.enableMultiblock();
                if (feedback != null) {
                    PlayerUtils.sendMessageToPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITextComponent)Utils.localize(SCContent.blockPocketManager.func_149739_a() + ".name", new Object[0]), (ITextComponent)feedback, TextFormatting.DARK_AQUA, true);
                }
            }
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        } else if (button.field_146127_k == this.sizeButton.field_146127_k) {
            this.size += 4;
            if (this.size > 25) {
                this.size = 5;
            }
            int newMin = (-this.size + 2) / 2;
            int newMax = (this.size - 2) / 2;
            int newOffset = this.te.autoBuildOffset > 0 ? Math.min(this.te.autoBuildOffset, newMax) : Math.max(this.te.autoBuildOffset, newMin);
            this.updateMaterialInformation(false);
            this.te.size = this.size;
            this.offsetSlider.minValue = newMin;
            this.offsetSlider.maxValue = newMax;
            this.te.autoBuildOffset = newOffset;
            this.offsetSlider.setValue(newOffset);
            this.offsetSlider.updateSlider();
            button.field_146126_j = Utils.localize("gui.securitycraft:blockPocketManager.size", this.size, this.size, this.size).func_150254_d();
            this.sync();
        } else if (button.field_146127_k == this.assembleButton.field_146127_k) {
            this.te.size = this.size;
            ITextComponent feedback = this.te.autoAssembleMultiblock();
            if (feedback != null) {
                PlayerUtils.sendMessageToPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITextComponent)Utils.localize(SCContent.blockPocketManager.func_149739_a() + ".name", new Object[0]), feedback, TextFormatting.DARK_AQUA);
            }
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        } else if (button.field_146127_k == this.outlineButton.field_146127_k) {
            this.te.toggleOutline();
            this.outlineButton.field_146126_j = Utils.localize("gui.securitycraft:blockPocketManager.outline." + (!this.te.showOutline ? "show" : "hide"), new Object[0]).func_150254_d();
            this.sync();
        }
    }

    private void sync() {
        SecurityCraft.network.sendToServer((IMessage)new SyncBlockPocketManager(this.te.func_174877_v(), this.te.size, this.te.showOutline, this.te.autoBuildOffset));
    }

    @Override
    public void onMouseRelease(int id) {
        if (id == this.offsetSlider.field_146127_k) {
            this.te.autoBuildOffset = this.offsetSlider.getValueInt();
            this.sync();
        }
    }

    private void updateMaterialInformation(boolean recalculateStoredStacks) {
        if (recalculateStoredStacks) {
            this.materialCounts[2] = 0;
            this.materialCounts[1] = 0;
            this.materialCounts[0] = 0;
            IItemHandler handler = this.te.getStorageHandler();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof ItemBlock)) continue;
                Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
                if (block == SCContent.blockPocketWall) {
                    this.materialCounts[0] = this.materialCounts[0] + stack.func_190916_E();
                    continue;
                }
                if (block == SCContent.reinforcedCrystalQuartz && stack.func_77960_j() >= 2) {
                    this.materialCounts[1] = this.materialCounts[1] + stack.func_190916_E();
                    continue;
                }
                if (block != SCContent.reinforcedCrystalQuartz || stack.func_77960_j() != 1) continue;
                this.materialCounts[2] = this.materialCounts[2] + stack.func_190916_E();
            }
        }
        this.wallsNeededOverall = (this.size - 2) * (this.size - 2) * 6;
        this.pillarsNeededOverall = (this.size - 2) * 12 - 1;
        this.wallsStillNeeded = this.wallsNeededOverall - this.materialCounts[0];
        this.pillarsStillNeeded = this.pillarsNeededOverall - this.materialCounts[1];
        this.chiseledStillNeeded = 8 - this.materialCounts[2];
        this.assembleButton.field_146124_l = this.isOwner && (this.field_146297_k.field_71439_g.func_184812_l_() || !this.te.enabled && this.storage && this.wallsStillNeeded <= 0 && this.pillarsStillNeeded <= 0 && this.chiseledStillNeeded <= 0);
    }

    @Override
    public void onChangeSliderValue(GuiSlider slider, String blockName, int id) {
        if (slider.field_146127_k == this.offsetSlider.field_146127_k) {
            slider.field_146126_j = slider.prefix + slider.getValueInt();
        }
    }
}

