/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.TileEntityLinkable;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public abstract class TileEntitySpecialDoor
extends TileEntityLinkable {
    private Option.OptionBoolean sendMessage = new Option.OptionBoolean("sendMessage", true);
    private Option.OptionInt signalLength = new Option.OptionInt(() -> ((TileEntitySpecialDoor)this).func_174877_v(), "signalLength", this.defaultSignalLength(), 0, 400, 5, true);

    @Override
    public void onModuleInserted(ItemStack stack, EnumModuleType module) {
        super.onModuleInserted(stack, module);
        this.handleModule(stack, module, false);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumModuleType module) {
        super.onModuleRemoved(stack, module);
        this.handleModule(stack, module, true);
    }

    private void handleModule(ItemStack stack, EnumModuleType module, boolean removed) {
        TileEntity otherTe;
        BlockDoor.EnumDoorHalf myHalf = (BlockDoor.EnumDoorHalf)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockDoor.field_176523_O);
        BlockPos otherPos = myHalf == BlockDoor.EnumDoorHalf.UPPER ? this.func_174877_v().func_177977_b() : this.func_174877_v().func_177984_a();
        IBlockState other = this.field_145850_b.func_180495_p(otherPos);
        if (other.func_177229_b((IProperty)BlockDoor.field_176523_O) != myHalf && (otherTe = this.field_145850_b.func_175625_s(otherPos)) instanceof TileEntitySpecialDoor) {
            TileEntitySpecialDoor otherDoorTe = (TileEntitySpecialDoor)otherTe;
            if (!removed && !otherDoorTe.hasModule(module)) {
                otherDoorTe.insertModule(stack);
            } else if (removed && otherDoorTe.hasModule(module)) {
                otherDoorTe.removeModule(module);
            }
        }
    }

    @Override
    protected void onLinkedBlockAction(EnumLinkedAction action, Object[] parameters, ArrayList<TileEntityLinkable> excludedTEs) {
        if (action == EnumLinkedAction.OPTION_CHANGED) {
            Option option = (Option)parameters[0];
            if (option.getName().equals(this.sendMessage.getName())) {
                this.sendMessage.copy(option);
            } else if (option.getName().equals(this.signalLength.getName())) {
                this.signalLength.copy(option);
            }
        }
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public abstract int defaultSignalLength();
}

