/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.HashMap;
import java.util.Map;
import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.HashedItem;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class TransitRequest {
    private Map<HashedItem, Pair<Integer, Map<Integer, Integer>>> itemMap = new HashMap<HashedItem, Pair<Integer, Map<Integer, Integer>>>();

    public static TransitRequest getFromTransport(TransporterStack stack) {
        return TransitRequest.getFromStack(stack.itemStack);
    }

    public static TransitRequest getFromStack(ItemStack stack) {
        TransitRequest ret = new TransitRequest();
        ret.addItem(stack, -1);
        return ret;
    }

    public static TransitRequest buildInventoryMap(TileEntity tile, EnumFacing side, int amount) {
        return TransitRequest.buildInventoryMap(tile, side, amount, new Finder.FirstFinder());
    }

    public static TransitRequest buildInventoryMap(TileEntity tile, EnumFacing side, int amount, Finder finder) {
        TransitRequest ret = new TransitRequest();
        HashMap<HashedItem, Integer> itemCountMap = new HashMap<HashedItem, Integer>();
        if (!InventoryUtils.assertItemHandler("TransitRequest", tile, side.func_176734_d())) {
            return ret;
        }
        IItemHandler inventory = InventoryUtils.getItemHandler(tile, side.func_176734_d());
        for (int i = inventory.getSlots() - 1; i >= 0; --i) {
            int toUse;
            ItemStack stack = inventory.extractItem(i, amount, true);
            if (stack.func_190926_b() || !finder.modifies(stack)) continue;
            HashedItem hashed = new HashedItem(stack);
            int currentCount = itemCountMap.getOrDefault(hashed, -1);
            int n = toUse = currentCount != -1 ? Math.min(stack.func_190916_E(), amount - currentCount) : stack.func_190916_E();
            if (toUse == 0) continue;
            ret.addItem(StackUtils.size(stack, toUse), i);
            if (currentCount != -1) {
                itemCountMap.put(hashed, currentCount + toUse);
                continue;
            }
            itemCountMap.put(hashed, toUse);
        }
        return ret;
    }

    public Map<HashedItem, Pair<Integer, Map<Integer, Integer>>> getItemMap() {
        return this.itemMap;
    }

    public boolean isEmpty() {
        return this.itemMap.isEmpty();
    }

    public void addItem(ItemStack stack, int slot) {
        HashedItem hashed = new HashedItem(stack);
        if (!this.itemMap.containsKey(hashed)) {
            HashMap<Integer, Integer> slotMap = new HashMap<Integer, Integer>();
            slotMap.put(slot, stack.func_190916_E());
            this.itemMap.put(hashed, (Pair<Integer, Map<Integer, Integer>>)Pair.of((Object)stack.func_190916_E(), slotMap));
        } else {
            Pair<Integer, Map<Integer, Integer>> itemInfo = this.itemMap.get(hashed);
            int count = (Integer)itemInfo.getLeft() + stack.func_190916_E();
            Map slotMap = (Map)itemInfo.getRight();
            slotMap.put(slot, stack.func_190916_E());
            this.itemMap.put(hashed, (Pair<Integer, Map<Integer, Integer>>)Pair.of((Object)count, (Object)slotMap));
        }
    }

    public ItemStack getSingleStack() {
        return this.itemMap.keySet().iterator().next().getStack();
    }

    public boolean hasType(ItemStack stack) {
        return this.itemMap.keySet().stream().anyMatch(item -> InventoryUtils.areItemsStackable(stack, item.getStack()));
    }

    public static class TransitResponse {
        public static final TransitResponse EMPTY = new TransitResponse();
        private Map<Integer, Integer> idMap = new HashMap<Integer, Integer>();
        private ItemStack toSend = ItemStack.field_190927_a;

        private TransitResponse() {
        }

        public TransitResponse(ItemStack i, Map<Integer, Integer> slots) {
            this.toSend = i;
            int amount = this.getSendingAmount();
            for (Map.Entry<Integer, Integer> entry : slots.entrySet()) {
                int toUse = Math.min(amount, entry.getValue());
                this.idMap.put(entry.getKey(), toUse);
                if ((amount -= toUse) != 0) continue;
                break;
            }
        }

        public ItemStack getStack() {
            return this.toSend;
        }

        public int getSendingAmount() {
            return this.toSend.func_190916_E();
        }

        public boolean isEmpty() {
            return this == EMPTY || this.idMap.isEmpty() || this.toSend != null && this.toSend.func_190926_b();
        }

        public ItemStack getRejected(ItemStack orig) {
            return StackUtils.size(orig, orig.func_190916_E() - this.getSendingAmount());
        }

        public InvStack getInvStack(TileEntity tile, EnumFacing side) {
            return new InvStack(tile, this.toSend, this.idMap, side);
        }
    }
}

